/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.util;

import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector2i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public class VectorUtil {
    public static boolean less(Vector3ic left, Vector3ic right) {
        return left.x() < right.x() && left.y() < right.y() && left.z() < right.z();
    }

    public static boolean less(Vector3ic left, BlockPos right) {
        return left.x() < right.m_123341_() && left.y() < right.m_123342_() && left.z() < right.m_123343_();
    }

    public static boolean less(BlockPos left, Vector3ic right) {
        return VectorUtil.greater(right, left);
    }

    public static boolean greater(Vector3ic left, Vector3ic right) {
        return left.x() > right.x() && left.y() > right.y() && left.z() > right.z();
    }

    public static boolean greater(Vector3ic left, BlockPos right) {
        return left.x() > right.m_123341_() && left.y() > right.m_123342_() && left.z() > right.m_123343_();
    }

    public static boolean greater(BlockPos left, Vector3ic right) {
        return VectorUtil.less(right, left);
    }

    public static boolean lequal(Vector3ic left, Vector3ic right) {
        return left.x() <= right.x() && left.y() <= right.y() && left.z() <= right.z();
    }

    public static boolean lequal(Vector3ic left, BlockPos right) {
        return left.x() <= right.m_123341_() && left.y() <= right.m_123342_() && left.z() <= right.m_123343_();
    }

    public static boolean grequal(Vector3ic left, Vector3ic right) {
        return left.x() >= right.x() && left.y() >= right.y() && left.z() >= right.z();
    }

    public static boolean grequal(Vector3ic left, BlockPos right) {
        return left.x() >= right.m_123341_() && left.y() >= right.m_123342_() && left.z() >= right.m_123343_();
    }

    public static Vector3i fromBlockPos(BlockPos blockPos) {
        return VectorUtil.fromBlockPos(blockPos, new Vector3i());
    }

    public static Vector3i fromBlockPos(BlockPos blockPos, Vector3i vector) {
        return vector.set(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public static Vector3i fromBlockPos(long blockPos) {
        return VectorUtil.fromBlockPos(blockPos, new Vector3i());
    }

    public static Vector3i fromBlockPos(long blockPos, Vector3i vector) {
        return vector.set(BlockPos.m_121983_((long)blockPos), BlockPos.m_122008_((long)blockPos), BlockPos.m_122015_((long)blockPos));
    }

    public static long toBlockPosLong(Vector3ic vector) {
        return BlockPos.m_121882_((int)vector.x(), (int)vector.y(), (int)vector.z());
    }

    public static Vector2i fromChunkPos(ChunkPos chunkPos) {
        return VectorUtil.fromChunkPos(chunkPos, new Vector2i());
    }

    public static Vector2i fromChunkPos(ChunkPos chunkPos, Vector2i vector) {
        return vector.set(chunkPos.f_45578_, chunkPos.f_45579_);
    }

    public static Vector2i fromChunkPos(long chunkPos) {
        return VectorUtil.fromChunkPos(chunkPos, new Vector2i());
    }

    public static Vector2i fromChunkPos(long chunkPos, Vector2i vector) {
        return vector.set(ChunkPos.m_45592_((long)chunkPos), ChunkPos.m_45602_((long)chunkPos));
    }

    public static Vector3i fromSectionPos(SectionPos sectionPos) {
        return VectorUtil.fromSectionPos(sectionPos, new Vector3i());
    }

    public static Vector3i fromSectionPos(SectionPos sectionPos, Vector3i vector) {
        return vector.set(sectionPos.m_123341_(), sectionPos.m_123342_(), sectionPos.m_123343_());
    }

    public static Vector3i fromSectionPos(long sectionPos) {
        return VectorUtil.fromSectionPos(sectionPos, new Vector3i());
    }

    public static Vector3i fromSectionPos(long sectionPos, Vector3i vector) {
        return vector.set(SectionPos.m_123213_((long)sectionPos), SectionPos.m_123225_((long)sectionPos), SectionPos.m_123230_((long)sectionPos));
    }

    public static long blockPosToChunkPosLong(Vector3ic blockpos) {
        return ChunkPos.m_45589_((int)SectionPos.m_123171_((int)blockpos.x()), (int)SectionPos.m_123171_((int)blockpos.z()));
    }

    public static String asString(Vector3ic vector) {
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.ENGLISH);
        return "(" + formatter.format(vector.x()) + " " + formatter.format(vector.y()) + " " + formatter.format(vector.z()) + ")";
    }
}

