/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config.spec;

import java.lang.reflect.Field;
import java.util.function.BiFunction;
import net.roguelogix.phosphophyllite.config.ConfigValue;
import net.roguelogix.phosphophyllite.config.spec.ConfigOptionsDefaults;
import net.roguelogix.phosphophyllite.config.spec.DefinitionError;
import net.roguelogix.phosphophyllite.config.spec.SpecNumberNode;
import net.roguelogix.phosphophyllite.config.spec.SpecObjectNode;
import net.roguelogix.phosphophyllite.parsers.Element;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.TriConsumer;

@NonnullDefault
public class SpecFloatNode
extends SpecNumberNode {
    private final FloatType type;
    public final double lowerBound;
    public final double upperBound;
    public final double defaultValue;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SpecFloatNode(SpecObjectNode parent, Field field, ConfigOptionsDefaults defaults) {
        super(parent, field, defaults);
        ConfigValue annotation = field.getAnnotation(ConfigValue.class);
        String range = annotation.range().trim().substring(1, annotation.range().length() - 1).trim();
        String[] bounds = range.split(",");
        String lowerBoundStr = "";
        String upperBoundStr = "";
        if (bounds.length == 2) {
            lowerBoundStr = bounds[0].trim();
            upperBoundStr = bounds[1].trim();
        } else {
            if (range.length() == 0) {
                throw new DefinitionError("Incomplete range given");
            }
            if (range.length() != 1) {
                if (bounds.length != 1) {
                    throw new DefinitionError("Incomplete range given");
                }
                if (range.charAt(0) == ',') {
                    upperBoundStr = bounds[0];
                } else {
                    if (range.charAt(range.length() - 1) != ',') throw new DefinitionError("Incomplete range given");
                    lowerBoundStr = bounds[0];
                }
            } else if (range.charAt(0) != ',') {
                throw new DefinitionError("Incomplete range given");
            }
        }
        double lowerBound = Double.MIN_VALUE;
        if (lowerBoundStr.length() != 0) {
            lowerBound = Double.parseDouble(lowerBoundStr);
        }
        double upperBound = Double.MAX_VALUE;
        if (upperBoundStr.length() != 0) {
            upperBound = Double.parseDouble(upperBoundStr);
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.defaultValue = (Double)this.currentValueObject();
        this.type = FloatType.fromClass(field.getType());
    }

    @Override
    public String defaultValueAsString() {
        return String.valueOf(this.defaultValue);
    }

    @Override
    public String currentValueAsString() {
        return this.currentValueObject().toString();
    }

    @Override
    public void writeFromString(String string) {
        this.type.write(this.field, this.parent.object(), Double.parseDouble(string));
    }

    @Override
    public boolean isValueValid(String valueString) {
        double val;
        try {
            val = Double.parseDouble(valueString);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return this.isValueValid(val);
    }

    public boolean isValueValid(double val) {
        if (this.lowerInclusive && val != this.lowerBound || val < this.lowerBound) {
            return false;
        }
        if (this.upperInclusive && val != this.upperBound || val > this.upperBound) {
            return false;
        }
        return false;
    }

    @Override
    public String lowerBoundAsString() {
        return String.valueOf(this.lowerBound);
    }

    @Override
    public String upperBoundAsString() {
        return String.valueOf(this.upperBound);
    }

    @Override
    public void writeDefault() {
        this.type.write(this.field, this.parent.object(), this.defaultValue);
    }

    @Override
    public Element generateDefaultElement() {
        return new Element(Element.Type.Number, this.generateComment(), this.name, this.defaultValue);
    }

    @Override
    public Element generateCurrentElement() {
        return new Element(Element.Type.Number, this.generateComment(), this.name, this.currentValueObject());
    }

    @Override
    public Element generateSyncElement() {
        return new Element(Element.Type.Number, null, this.name, this.currentValueObject());
    }

    @Override
    public String generateComment() {
        StringBuilder comment = new StringBuilder(this.baseComment);
        ConfigValue fieldAnnotation = this.field.getAnnotation(ConfigValue.class);
        if (!fieldAnnotation.range().equals("(,)")) {
            if (comment.length() != 0) {
                comment.append('\n');
            }
            comment.append("Valid range: ").append(fieldAnnotation.range());
        }
        if (comment.length() != 0) {
            comment.append('\n');
        }
        comment.append("Default: ");
        comment.append(this.defaultValue);
        return comment.toString();
    }

    @Override
    public Element correctToValidState(Element element) {
        if (element.type != Element.Type.Number || !(element.value instanceof Number)) {
            return this.generateDefaultElement();
        }
        if (this.isValueValid(element.asLong())) {
            return element;
        }
        double val = element.asDouble();
        val = Math.min(Math.max(val, this.lowerBound), this.upperBound);
        if (!this.lowerInclusive && val == this.lowerBound) {
            val = this.type.nextAfter(this.lowerBound, Double.POSITIVE_INFINITY);
        }
        if (!this.upperInclusive && val == this.upperBound) {
            val = this.type.nextAfter(this.lowerBound, Double.NEGATIVE_INFINITY);
        }
        return new Element(Element.Type.Number, this.generateComment(), this.name, val);
    }

    @Override
    public void writeElement(Element element) {
        this.type.write(this.field, this.parent.object(), element.asDouble());
    }

    public static enum FloatType {
        FLOAT((f, o, l) -> f.setFloat(o, l.floatValue()), (val, direction) -> Math.nextAfter(val.floatValue(), (double)direction)),
        DOUBLE(Field::setDouble, Math::nextAfter);

        private final TriConsumer.WithException<Field, Object, Double, IllegalAccessException> writeFunction;
        private final BiFunction<Double, Double, Double> nextAfter;

        private FloatType(TriConsumer.WithException<Field, Object, Double, IllegalAccessException> writeFunction, BiFunction<Double, Double, Double> nextAfter) {
            this.writeFunction = writeFunction;
            this.nextAfter = nextAfter;
        }

        public void write(Field field, Object obj, double val) {
            try {
                this.writeFunction.accept(field, obj, val);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public static FloatType fromClass(Class<?> clazz) {
            if (clazz == Double.class || clazz == Double.TYPE) {
                return DOUBLE;
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return FLOAT;
            }
            throw new IllegalArgumentException();
        }

        public double nextAfter(double val, double direction) {
            return this.nextAfter.apply(val, direction);
        }
    }
}

