/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.client.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.phosphophyllite.client.gui.api.ITooltip;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class TooltipElement<T extends AbstractContainerMenu>
extends AbstractElement<T>
implements ITooltip {
    public boolean tooltipEnable;
    public Component tooltip;

    public TooltipElement(@Nonnull PhosphophylliteScreen<T> parent, int x, int y, int width, int height, @Nullable Component tooltip) {
        super(parent, x, y, width, height);
        this.tooltipEnable = tooltip != null;
        this.tooltip = tooltip;
    }

    @Override
    public void renderTooltip(@Nonnull PoseStack poseStack, int mouseX, int mouseY) {
        if (this.tooltipEnable && this.tooltip != null && this.m_5953_(mouseX, mouseY)) {
            this.parent.m_96597_(poseStack, Arrays.stream(this.tooltip.getString().split("\\n")).map(Component::m_237113_).collect(Collectors.toList()), mouseX, mouseY);
        }
    }

    @Override
    public void enable() {
        this.tooltipEnable = true;
    }

    @Override
    public void disable() {
        this.tooltipEnable = false;
    }
}

