/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.blocks.blackholes;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.roguelogix.phosphophyllite.blocks.blackholes.PowerBlackHoleTile;
import net.roguelogix.phosphophyllite.modular.block.PhosphophylliteBlock;
import net.roguelogix.phosphophyllite.registry.RegisterBlock;
import net.roguelogix.phosphophyllite.util.Util;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PowerBlackHole
extends PhosphophylliteBlock
implements EntityBlock {
    @RegisterBlock(name="power_black_hole", tileEntityClass=PowerBlackHoleTile.class)
    public static final PowerBlackHole INSTANCE = new PowerBlackHole();

    public PowerBlackHole() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return PowerBlackHoleTile.SUPPLIER.m_155267_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return (level, pos, state, entity) -> {
            assert (entity instanceof PowerBlackHoleTile);
            ((PowerBlackHoleTile)entity).tick();
        };
    }

    @Override
    public void onNeighborChange(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof PowerBlackHoleTile) {
            PowerBlackHoleTile whiteHoleTile = (PowerBlackHoleTile)tile;
            whiteHoleTile.updateCapability(Util.directionFromPositions(pos, fromPos), blockIn, fromPos);
        }
    }

    @Override
    public InteractionResult onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand == InteractionHand.MAIN_HAND && Util.isWrench(player.m_21205_().m_41720_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof PowerBlackHoleTile) {
                PowerBlackHoleTile tile = (PowerBlackHoleTile)blockEntity;
                if (player.m_6047_()) {
                    tile.rotateCapability(player);
                } else {
                    tile.nextOption(player);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

