/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.threading;

import java.util.ArrayList;

public class Event {
    private final ArrayList<Runnable> callbacks = new ArrayList();
    private volatile boolean wasTriggered = false;

    public boolean ready() {
        return this.wasTriggered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        if (this.wasTriggered) {
            return;
        }
        Event event = this;
        synchronized (event) {
            if (this.wasTriggered) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean join(int timeout) {
        if (this.wasTriggered) {
            return true;
        }
        Event event = this;
        synchronized (event) {
            if (this.wasTriggered) {
                return true;
            }
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.wasTriggered;
    }

    public synchronized void trigger() {
        if (this.wasTriggered) {
            return;
        }
        this.callbacks.forEach(Runnable::run);
        this.wasTriggered = true;
        this.notifyAll();
    }

    public synchronized void registerCallback(Runnable runnable) {
        if (this.wasTriggered) {
            runnable.run();
            return;
        }
        this.callbacks.add(runnable);
    }

    protected void finalize() {
        this.trigger();
    }
}

