/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.repack.tnjson;

import net.roguelogix.phosphophyllite.repack.tnjson.JsonSerializer;
import net.roguelogix.phosphophyllite.repack.tnjson.TnJson;

public class TnJsonBuilder
extends TnJson {
    boolean isKeyQuoted = true;
    char quoteSymbol = (char)34;
    boolean isFormated = false;
    boolean isStayReadable = false;
    boolean isAllowMultiRowString = false;
    boolean isKeepNull = false;
    IPathHandler pathHandler = null;
    ITypeHandler typeHandler = null;

    TnJsonBuilder() {
    }

    static TnJsonBuilder init() {
        return new TnJsonBuilder();
    }

    public TnJsonBuilder withoutKeyQuote() {
        this.isKeyQuoted = false;
        return this;
    }

    public TnJsonBuilder singleQuote() {
        this.quoteSymbol = (char)39;
        return this;
    }

    public TnJsonBuilder formated() {
        this.isFormated = true;
        return this;
    }

    public TnJsonBuilder readable() {
        this.isStayReadable = true;
        return this;
    }

    public TnJsonBuilder allowMultiRowString() {
        this.isAllowMultiRowString = true;
        return this;
    }

    public TnJsonBuilder keepNull() {
        this.isKeepNull = true;
        return this;
    }

    public TnJsonBuilder handlePath(IPathHandler pathHandler) {
        this.pathHandler = pathHandler;
        return this;
    }

    public TnJsonBuilder handleType(ITypeHandler typeHandler) {
        this.typeHandler = typeHandler;
        return this;
    }

    @Override
    public String buildJson(Object data) {
        return JsonSerializer.toJson(data, this);
    }

    public static interface IPathHandler {
        public Object handlePath(String var1, Object var2);
    }

    public static interface ITypeHandler {
        public Object handleType(Object var1);
    }
}

