/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.bettermipmaps;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.Locale;
import java.util.Objects;
import net.coderbot.iris.helpers.ColorSRGB;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={TextureAtlasSprite.class})
public class MixinTextureAtlasSprite {
    private static final float[] SRGB_TO_LINEAR = new float[256];

    @ModifyVariable(method={"<init>"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;animatedTexture:Lnet/minecraft/client/renderer/texture/TextureAtlasSprite$AnimatedTexture;"), argsOnly=true)
    private NativeImage iris$beforeGenerateMipLevels(NativeImage nativeImage, TextureAtlas arg, TextureAtlasSprite.Info info) {
        ResourceLocation name = Objects.requireNonNull(info).m_118431_();
        if (name.m_135815_().contains("leaves")) {
            return nativeImage;
        }
        MixinTextureAtlasSprite.iris$fillInTransparentPixelColors(nativeImage);
        return nativeImage;
    }

    @Unique
    private static void iris$fillInTransparentPixelColors(NativeImage nativeImage) {
        long ppPixel = MixinTextureAtlasSprite.getPointerRGBA(nativeImage);
        int pixelCount = nativeImage.m_85084_() * nativeImage.m_84982_();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float totalWeight = 0.0f;
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            long pPixel = ppPixel + (long)(pixelIndex * 4);
            int color = MemoryUtil.memGetInt((long)pPixel);
            int alpha = NativeImage.m_84983_((int)color);
            if (alpha == 0) continue;
            float weight = alpha;
            r += ColorSRGB.srgbToLinear(NativeImage.m_85085_((int)color)) * weight;
            g += ColorSRGB.srgbToLinear(NativeImage.m_85103_((int)color)) * weight;
            b += ColorSRGB.srgbToLinear(NativeImage.m_85119_((int)color)) * weight;
            totalWeight += weight;
        }
        if (totalWeight == 0.0f) {
            return;
        }
        int averageColor = ColorSRGB.linearToSrgb(r /= totalWeight, g /= totalWeight, b /= totalWeight, 0);
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            long pPixel = ppPixel + (long)(pixelIndex * 4);
            int color = MemoryUtil.memGetInt((long)pPixel);
            int alpha = NativeImage.m_84983_((int)color);
            if (alpha != 0) continue;
            MemoryUtil.memPutInt((long)pPixel, (int)averageColor);
        }
    }

    private static long getPointerRGBA(NativeImage nativeImage) {
        if (nativeImage.m_85102_() != NativeImage.Format.RGBA) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Tried to get pointer to RGBA pixel data on NativeImage of wrong format; have %s", nativeImage.m_85102_()));
        }
        return nativeImage.f_84964_;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            MixinTextureAtlasSprite.SRGB_TO_LINEAR[i] = (float)Math.pow((double)i / 255.0, 2.2);
        }
    }
}

