/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterUnsafe;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import net.coderbot.iris.compat.sodium.impl.block_context.BlockContextHolder;
import net.coderbot.iris.compat.sodium.impl.block_context.ContextAwareVertexWriter;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPModelVertexType;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.NormI8;
import net.coderbot.iris.vertices.NormalHelper;
import org.lwjgl.system.MemoryUtil;

public class XHFPModelVertexBufferWriterUnsafe
extends VertexBufferWriterUnsafe
implements ModelVertexSink,
ContextAwareVertexWriter {
    private final QuadViewTerrain.QuadViewTerrainUnsafe quad = new QuadViewTerrain.QuadViewTerrainUnsafe();
    private final Vector3f normal = new Vector3f();
    private BlockContextHolder contextHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;

    public XHFPModelVertexBufferWriterUnsafe(VertexBufferView backingBuffer) {
        super(backingBuffer, (BufferVertexType)IrisModelVertexFormats.MODEL_VERTEX_XHFP);
    }

    @Override
    public void copyQuadAndFlipNormal() {
        this.ensureCapacity(4);
        MemoryUtil.memCopy((long)(this.writePointer - 160L), (long)this.writePointer, (long)160L);
        int packedNormal = MemoryUtil.memGetInt((long)(this.writePointer + 28L));
        int inverted = NormalHelper.invertPackedNormal(packedNormal);
        MemoryUtil.memPutInt((long)(this.writePointer + 28L), (int)inverted);
        MemoryUtil.memPutInt((long)(this.writePointer + 28L + 40L), (int)inverted);
        MemoryUtil.memPutInt((long)(this.writePointer + 28L + 80L), (int)inverted);
        MemoryUtil.memPutInt((long)(this.writePointer + 28L + 120L), (int)inverted);
        for (int i = 0; i < 4; ++i) {
            this.advance();
        }
        this.flush();
    }

    public void writeVertex(float posX, float posY, float posZ, int color, float u, float v, int light, int chunkId) {
        this.uSum += u;
        this.vSum += v;
        this.writeQuadInternal(posX, posY, posZ, color, u, v, light, this.contextHolder.blockId, this.contextHolder.renderType, chunkId, this.contextHolder.ignoreMidBlock ? 0 : ExtendedDataHelper.computeMidBlock(posX, posY, posZ, this.contextHolder.localPosX, this.contextHolder.localPosY, this.contextHolder.localPosZ));
    }

    private void writeQuadInternal(float posX, float posY, float posZ, int color, float u, float v, int light, short materialId, short renderType, int chunkId, int packedMidBlock) {
        long i = this.writePointer;
        ++this.vertexCount;
        MemoryUtil.memPutShort((long)(i + 0L), (short)XHFPModelVertexType.encodePosition(posX));
        MemoryUtil.memPutShort((long)(i + 2L), (short)XHFPModelVertexType.encodePosition(posY));
        MemoryUtil.memPutShort((long)(i + 4L), (short)XHFPModelVertexType.encodePosition(posZ));
        MemoryUtil.memPutShort((long)(i + 6L), (short)((short)chunkId));
        MemoryUtil.memPutInt((long)(i + 8L), (int)color);
        MemoryUtil.memPutShort((long)(i + 12L), (short)XHFPModelVertexType.encodeBlockTexture(u));
        MemoryUtil.memPutShort((long)(i + 14L), (short)XHFPModelVertexType.encodeBlockTexture(v));
        MemoryUtil.memPutInt((long)(i + 16L), (int)light);
        MemoryUtil.memPutShort((long)(i + 32L), (short)materialId);
        MemoryUtil.memPutShort((long)(i + 34L), (short)renderType);
        MemoryUtil.memPutInt((long)(i + 36L), (int)packedMidBlock);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            short midU = XHFPModelVertexType.encodeBlockTexture(this.uSum);
            short midV = XHFPModelVertexType.encodeBlockTexture(this.vSum);
            MemoryUtil.memPutShort((long)(i + 20L), (short)midU);
            MemoryUtil.memPutShort((long)(i + 20L - 40L), (short)midU);
            MemoryUtil.memPutShort((long)(i + 20L - 80L), (short)midU);
            MemoryUtil.memPutShort((long)(i + 20L - 120L), (short)midU);
            MemoryUtil.memPutShort((long)(i + 22L), (short)midV);
            MemoryUtil.memPutShort((long)(i + 22L - 40L), (short)midV);
            MemoryUtil.memPutShort((long)(i + 22L - 80L), (short)midV);
            MemoryUtil.memPutShort((long)(i + 22L - 120L), (short)midV);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(i, 40);
            NormalHelper.computeFaceNormal(this.normal, this.quad);
            int packedNormal = NormI8.pack(this.normal.x, this.normal.y, this.normal.z, 0.0f);
            MemoryUtil.memPutInt((long)(i + 28L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(i + 28L - 40L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(i + 28L - 80L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(i + 28L - 120L), (int)packedNormal);
            int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            MemoryUtil.memPutInt((long)(i + 24L), (int)tangent);
            MemoryUtil.memPutInt((long)(i + 24L - 40L), (int)tangent);
            MemoryUtil.memPutInt((long)(i + 24L - 80L), (int)tangent);
            MemoryUtil.memPutInt((long)(i + 24L - 120L), (int)tangent);
        }
        this.advance();
    }

    @Override
    public void iris$setContextHolder(BlockContextHolder holder) {
        this.contextHolder = holder;
    }
}

