/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.buffer;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.Collections;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.buffer.ShaderStorageBuffer;
import net.coderbot.iris.gl.sampler.SamplerLimits;

public class ShaderStorageBufferHolder {
    private ShaderStorageBuffer[] buffers;
    private boolean destroyed = false;

    public ShaderStorageBufferHolder(Int2IntArrayMap overrides) {
        this.buffers = new ShaderStorageBuffer[(Integer)Collections.max(overrides.keySet()) + 1];
        overrides.forEach((index, size) -> {
            if ((long)size.intValue() > IrisRenderSystem.getVRAM()) {
                throw new OutOfVideoMemoryError("We only have " + ShaderStorageBufferHolder.toMib(IrisRenderSystem.getVRAM()) + "MiB of RAM to work with, but the pack is requesting " + size + "! Can't continue.");
            }
            int buffer = GlStateManager.m_84537_();
            GlStateManager.m_84480_((int)37074, (int)buffer);
            IrisRenderSystem.bufferStorage(37074, size.intValue(), 0);
            IrisRenderSystem.clearBufferSubData(37074, 33321, 0L, size.intValue(), 6403, 5120, new int[]{0});
            if (index > SamplerLimits.get().getMaxShaderStorageUnits()) {
                throw new IllegalStateException("We don't have enough SSBO units??? (index: " + index + ", max: " + SamplerLimits.get().getMaxShaderStorageUnits());
            }
            IrisRenderSystem.bindBufferBase(37074, index, buffer);
            this.buffers[index.intValue()] = new ShaderStorageBuffer(buffer, (int)index, size.intValue());
        });
        GlStateManager.m_84480_((int)37074, (int)0);
    }

    private static long toMib(long x) {
        return x / 1024L / 1024L;
    }

    public void setupBuffers() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed buffer objects");
        }
        for (ShaderStorageBuffer buffer : this.buffers) {
            buffer.bind();
        }
    }

    public void destroyBuffers() {
        for (ShaderStorageBuffer buffer : this.buffers) {
            buffer.destroy();
        }
        this.buffers = null;
        this.destroyed = true;
    }

    private static class OutOfVideoMemoryError
    extends RuntimeException {
        public OutOfVideoMemoryError(String s) {
            super(s);
        }
    }
}

