/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.handlers;

import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.BeaverFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FairyFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.GuardianFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.HeadlessFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.util.FamiliarUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FamiliarEventHandler {
    @SubscribeEvent
    public static void beaverFindTree(SaplingGrowTreeEvent event) {
        LevelAccessor world = event.getLevel();
        BlockPos pos = event.getPos();
        List beavers = event.getLevel().m_6443_(BeaverFamiliarEntity.class, new AABB(pos).m_82400_(30.0), b -> !b.isSitting() && b.isEffectEnabled(b.getFamiliarOwner()));
        if (!beavers.isEmpty()) {
            BeaverFamiliarEntity beaver = (BeaverFamiliarEntity)beavers.get(world.m_213780_().m_188503_(beavers.size()));
            beaver.setTreeTarget(pos);
        }
    }

    @SubscribeEvent
    public static void beaverHarvest(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (!event.getState().m_204336_(BlockTags.f_13106_)) {
            return;
        }
        if (!player.m_21023_((MobEffect)OccultismEffects.BEAVER_HARVEST.get())) {
            return;
        }
        int level = player.m_21124_((MobEffect)OccultismEffects.BEAVER_HARVEST.get()).m_19564_();
        event.setNewSpeed(event.getNewSpeed() * (float)(level + 3));
    }

    @SubscribeEvent
    public static void dodge(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_21023_((MobEffect)OccultismEffects.MUMMY_DODGE.get())) {
            return;
        }
        DamageSource source = event.getSource();
        if (!(source instanceof EntityDamageSource) || source.m_19372_() || source.m_19378_()) {
            return;
        }
        int level = entity.m_21124_((MobEffect)OccultismEffects.MUMMY_DODGE.get()).m_19564_();
        boolean dodge = entity.m_217043_().m_188500_() < (double)((float)(level + 1) * 0.1f);
        event.setCanceled(dodge);
        if (dodge) {
            OccultismAdvancements.FAMILIAR.trigger(entity, FamiliarTrigger.Type.MUMMY_DODGE);
        }
    }

    @SubscribeEvent
    public static void livingDeathEvent(LivingDeathEvent event) {
        FamiliarEventHandler.guardianUltimateSacrifice(event);
        FamiliarEventHandler.headlessStealHead(event);
        FamiliarEventHandler.fairySave(event);
        FamiliarEventHandler.lifesteal(event);
    }

    private static void lifesteal(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (!attacker.m_21023_((MobEffect)OccultismEffects.BAT_LIFESTEAL.get())) {
            return;
        }
        attacker.m_5634_((float)(1 + attacker.m_21124_((MobEffect)OccultismEffects.BAT_LIFESTEAL.get()).m_19564_()));
    }

    private static void fairySave(LivingDeathEvent event) {
        IFamiliar familiar;
        LivingEntity entity;
        block7: {
            block6: {
                entity = event.getEntity();
                if (event.getSource().m_19378_() || !(entity instanceof IFamiliar)) break block6;
                familiar = (IFamiliar)entity;
                if (entity.m_6095_() != OccultismEntities.GUARDIAN_FAMILIAR.get() && entity.m_6095_() != OccultismEntities.FAIRY_FAMILIAR.get()) break block7;
            }
            return;
        }
        LivingEntity owner = familiar.getFamiliarOwner();
        if (owner == null || !FamiliarUtil.isFamiliarEnabled(owner, (EntityType<? extends IFamiliar>)((EntityType)OccultismEntities.FAIRY_FAMILIAR.get()))) {
            return;
        }
        FairyFamiliarEntity fairy = (FairyFamiliarEntity)FamiliarUtil.getFamiliar(owner, (EntityType)OccultismEntities.FAIRY_FAMILIAR.get());
        if (fairy == null || !fairy.saveFamiliar(familiar)) {
            return;
        }
        event.setCanceled(true);
        entity.m_21153_(2.0f);
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 2));
        if (!owner.f_19853_.f_46443_) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.FAIRY_SAVE);
        }
    }

    @SubscribeEvent
    public static void livingDamageEvent(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!FamiliarUtil.isFamiliarEnabled((LivingEntity)player, (EntityType<? extends IFamiliar>)((EntityType)OccultismEntities.HEADLESS_FAMILIAR.get()))) {
            return;
        }
        EntityType headType = event.getEntity().m_6095_();
        if (!FamiliarUtil.hasFamiliar((LivingEntity)player, (EntityType)OccultismEntities.HEADLESS_FAMILIAR.get(), h -> h.getHeadType() == headType)) {
            return;
        }
        event.setAmount(event.getAmount() * 1.3f);
    }

    private static void headlessStealHead(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!FamiliarUtil.isFamiliarEnabled((LivingEntity)player, (EntityType<? extends IFamiliar>)((EntityType)OccultismEntities.HEADLESS_FAMILIAR.get()))) {
            return;
        }
        List<HeadlessFamiliarEntity> headlesses = FamiliarUtil.getAllFamiliars((LivingEntity)player, (EntityType)OccultismEntities.HEADLESS_FAMILIAR.get());
        if (!headlesses.isEmpty() && event.getEntity().m_6095_() == OccultismEntities.CTHULHU_FAMILIAR.get()) {
            OccultismAdvancements.FAMILIAR.trigger((LivingEntity)player, FamiliarTrigger.Type.HEADLESS_CTHULHU_HEAD);
        }
        headlesses.forEach(h -> h.setHeadType(event.getEntity().m_6095_()));
    }

    private static void guardianUltimateSacrifice(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (event.getSource().m_19378_() || !((livingEntity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!FamiliarUtil.isFamiliarEnabled((LivingEntity)player, (EntityType<? extends IFamiliar>)((EntityType)OccultismEntities.GUARDIAN_FAMILIAR.get()))) {
            return;
        }
        GuardianFamiliarEntity guardian = (GuardianFamiliarEntity)FamiliarUtil.getFamiliar((LivingEntity)player, (EntityType)OccultismEntities.GUARDIAN_FAMILIAR.get());
        if (guardian == null) {
            return;
        }
        if (!guardian.sacrifice()) {
            return;
        }
        event.setCanceled(true);
        player.m_21153_(1.0f);
        player.m_21219_();
        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
    }

    @SubscribeEvent
    public static void beholderBlindnessImmune(MobEffectEvent.Applicable event) {
        EntityType beholder;
        if (event.getEffectInstance().m_19544_() != MobEffects.f_19610_) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!FamiliarUtil.hasFamiliar(entity, beholder = (EntityType)OccultismEntities.BEHOLDER_FAMILIAR.get(), FamiliarEntity::hasBlacksmithUpgrade)) {
            return;
        }
        event.setResult(Event.Result.DENY);
    }
}

