/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.level.cave;

import com.klikli_dev.occultism.common.level.cave.CaveDecoratordata;
import com.klikli_dev.occultism.common.level.cave.ICaveDecorator;
import com.klikli_dev.occultism.common.level.multichunk.IMultiChunkSubFeature;
import com.klikli_dev.occultism.common.level.multichunk.MultiChunkFeature;
import com.klikli_dev.occultism.common.level.multichunk.MultiChunkFeatureConfig;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.Math3DUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.phys.AABB;

public class SphericalCaveSubFeature
implements IMultiChunkSubFeature {
    public static Set<BlockPos> sphericalCaves = new HashSet<BlockPos>();
    protected ICaveDecorator caveDecorator;
    protected int radius;
    protected int maxRandomRadiusOffset;
    protected int additionalSpheres;
    protected int maxRandomAdditionalSpheres;

    public SphericalCaveSubFeature(ICaveDecorator caveDecorator, int radius, int maxRandomRadiusOffset) {
        this(caveDecorator, radius, maxRandomRadiusOffset, 3, 2);
    }

    public SphericalCaveSubFeature(ICaveDecorator caveDecorator, int radius, int maxRandomRadiusOffset, int additionalSpheres, int maxRandomAdditionalSpheres) {
        this.caveDecorator = caveDecorator;
        this.radius = radius;
        this.maxRandomRadiusOffset = maxRandomRadiusOffset;
        this.additionalSpheres = additionalSpheres;
        this.maxRandomAdditionalSpheres = maxRandomAdditionalSpheres;
    }

    @Override
    public boolean place(WorldGenLevel reader, ChunkGenerator generator, RandomSource rand, BlockPos rootPosition, AABB bounds, MultiChunkFeatureConfig config) {
        if (reader.m_46861_(rootPosition)) {
            return false;
        }
        sphericalCaves.add(rootPosition);
        ChunkPos rootChunk = new ChunkPos(rootPosition);
        long seed = MultiChunkFeature.getLargeFeatureWithSaltSeed(reader.m_7328_(), rootChunk.f_45578_, rootChunk.f_45579_, config.featureSeedSalt);
        rand.m_188584_(seed);
        ArrayList<Sphere> spheres = new ArrayList<Sphere>();
        int radiusBase = this.radius + rand.m_188503_(this.maxRandomRadiusOffset);
        int radius = (int)((float)radiusBase * 0.2f) + rand.m_188503_(8);
        spheres.add(this.generateSphere(reader, rand, rootPosition, radius, bounds));
        for (int i = 0; i < this.additionalSpheres + rand.m_188503_(this.maxRandomAdditionalSpheres); ++i) {
            Direction direction = Direction.Plane.HORIZONTAL.m_235690_(rand);
            spheres.add(this.generateSphere(reader, rand, rootPosition.m_5484_(direction, radius - 2), 2 * (int)((float)radius / 3.0f) + rand.m_188503_(8), bounds));
        }
        for (Sphere sphere : spheres) {
            this.hollowOutSphere(reader, rand, sphere.center, sphere.radius - 2, bounds);
            this.decorateSphere(reader, generator, rand, sphere.center, sphere.radius + 2, bounds, config);
        }
        spheres.clear();
        return true;
    }

    protected Sphere generateSphere(WorldGenLevel level, RandomSource rand, BlockPos position, int radius, AABB bounds) {
        return new Sphere(position, radius);
    }

    protected void hollowOutSphere(WorldGenLevel reader, RandomSource rand, BlockPos center, int radius, AABB bounds) {
        int j = radius;
        int k = radius / 2;
        int l = radius;
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos min = Math3DUtil.clamp(center.m_7918_(-j, -k, -l), bounds);
        BlockPos max = Math3DUtil.clamp(center.m_7918_(j, k, l), bounds);
        BlockPos.m_121940_((BlockPos)min, (BlockPos)max).forEach(blockPos -> {
            if (blockPos.m_123331_((Vec3i)center) <= (double)(f * f * Mth.m_14036_((float)rand.m_188501_(), (float)0.75f, (float)1.0f))) {
                BlockState currentState = reader.m_8055_(blockPos);
                this.setBlockSafely(reader, (BlockPos)blockPos, currentState, Blocks.f_50627_.m_49966_(), 2);
            }
        });
    }

    protected void decorateSphere(WorldGenLevel reader, ChunkGenerator generator, RandomSource rand, BlockPos center, int radius, AABB bounds, MultiChunkFeatureConfig config) {
        int j = radius;
        int k = radius / 2;
        int l = radius;
        CaveDecoratordata data = new CaveDecoratordata();
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos min = Math3DUtil.clamp(center.m_7918_(-j, -k, -l), bounds);
        BlockPos max = Math3DUtil.clamp(center.m_7918_(j, k, l), bounds);
        BlockPos.m_121940_((BlockPos)min, (BlockPos)max).forEach(blockPos -> {
            if (blockPos.m_123331_((Vec3i)center) <= (double)(f * f)) {
                this.caveDecorator.fill(reader, generator, rand, blockPos.m_7949_(), data, config);
            }
        });
        this.caveDecorator.finalPass(reader, generator, rand, data, config);
    }

    protected void setBlockSafely(WorldGenLevel level, BlockPos pPos, BlockState pCurrentState, BlockState pNewState, int pFlags) {
        if (pCurrentState.m_155947_() || pCurrentState.m_60734_() == Blocks.f_50752_ || pCurrentState.m_204336_(OccultismTags.WORLDGEN_BLACKLIST)) {
            return;
        }
        level.m_7731_(pPos, pNewState, pFlags);
    }

    public class Sphere {
        public BlockPos center;
        public int radius;

        public Sphere(BlockPos center, int radius) {
            this.center = center;
            this.radius = radius;
        }
    }
}

