/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.entity.LizardTail;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistTags;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Lizard
extends TamableAnimal
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Integer> VARIANT_ID = SynchedEntityData.m_135353_(Lizard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_TAIL = SynchedEntityData.m_135353_(Lizard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient TEMPT_INGREDIENT = Ingredient.m_204132_(NaturalistTags.ItemTags.LIZARD_TEMPT_ITEMS);
    private LizardAvoidEntityGoal<Player> avoidPlayersGoal;
    private int tailRegrowCooldown = 0;

    public Lizard(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new LizardTemptGoal(this, 0.6, TEMPT_INGREDIENT, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_5849_() {
        if (this.avoidPlayersGoal == null) {
            this.avoidPlayersGoal = new LizardAvoidEntityGoal<Player>(this, Player.class, 16.0f, 0.8, 1.33);
        }
        this.f_21345_.m_25363_(this.avoidPlayersGoal);
        if (!this.m_21824_()) {
            this.f_21345_.m_25352_(4, this.avoidPlayersGoal);
        }
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.f_19853_.f_46443_) {
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || TEMPT_INGREDIENT.test(stack) && !this.m_21824_();
            return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (TEMPT_INGREDIENT.test(stack) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                this.m_5634_(5.0f);
                if (!this.hasTail() && this.m_21223_() >= this.m_21233_()) {
                    this.setHasTail(true);
                    this.m_5496_(SoundEvents.f_12388_, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionResult = super.m_6071_(player, hand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            this.m_21839_(!this.m_21827_());
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        if (!TEMPT_INGREDIENT.test(stack)) {
            return super.m_6071_(player, hand);
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21839_(true);
            this.f_19853_.m_7605_((Entity)this, (byte)7);
            return InteractionResult.SUCCESS;
        }
        this.f_19853_.m_7605_((Entity)this, (byte)6);
        return InteractionResult.SUCCESS;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public int getVariant() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(VARIANT_ID)), (int)0, (int)3);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT_ID, (Object)variant);
    }

    public boolean hasTail() {
        return (Boolean)this.f_19804_.m_135370_(HAS_TAIL);
    }

    public void setHasTail(boolean hasTail) {
        this.f_19804_.m_135381_(HAS_TAIL, (Object)hasTail);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT_ID, (Object)0);
        this.f_19804_.m_135372_(HAS_TAIL, (Object)true);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("HasTail", this.hasTail());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setHasTail(compound.m_128471_("HasTail"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.hasTail() && this.m_21223_() <= this.m_21233_() / 2.0f) {
            this.setHasTail(false);
            this.m_5496_(SoundEvents.f_12388_, 1.0f, 1.0f);
            LizardTail lizardTail = (LizardTail)NaturalistEntityTypes.LIZARD_TAIL.get().m_20615_(this.f_19853_);
            if (lizardTail != null) {
                lizardTail.setVariant(this.getVariant());
                lizardTail.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.f_19853_.m_7967_((Entity)lizardTail);
            }
            for (Mob mob : this.f_19853_.m_6443_(Mob.class, this.m_20191_().m_82400_(8.0), entity -> entity.m_5448_() == this)) {
                mob.m_6710_((LivingEntity)lizardTail);
            }
            this.tailRegrowCooldown = 12000;
        }
        return super.m_6469_(source, amount);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.hasTail() && !this.f_19853_.m_5776_()) {
            if (this.tailRegrowCooldown > 0) {
                --this.tailRegrowCooldown;
            } else {
                this.m_5496_(SoundEvents.f_12388_, 1.0f, 1.0f);
                this.setHasTail(true);
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnData, @javax.annotation.Nullable CompoundTag dataTag) {
        Holder holder = level.m_204166_(this.m_20183_());
        if (holder.m_203565_(Biomes.f_48157_)) {
            this.setVariant(3);
        } else if (holder.m_203656_(BiomeTags.f_207610_)) {
            this.setVariant(0);
        } else if (holder.m_203565_(Biomes.f_48203_)) {
            this.setVariant(2);
        } else {
            this.setVariant(1);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("sit"));
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            event.getController().setAnimation(new AnimationBuilder().loop("walk"));
            event.getController().setAnimationSpeed(2.0);
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class LizardTemptGoal
    extends TemptGoal {
        @Nullable
        private Player selectedPlayer;
        private final Lizard lizard;

        public LizardTemptGoal(Lizard lizard, double speedModifier, Ingredient ingredient, boolean canScare) {
            super((PathfinderMob)lizard, speedModifier, ingredient, canScare);
            this.lizard = lizard;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.selectedPlayer == null && this.f_25924_.m_217043_().m_188503_(this.m_183277_(600)) == 0) {
                this.selectedPlayer = this.f_25925_;
            } else if (this.f_25924_.m_217043_().m_188503_(this.m_183277_(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        protected boolean m_7497_() {
            if (this.selectedPlayer != null && this.selectedPlayer.equals((Object)this.f_25925_)) {
                return false;
            }
            return super.m_7497_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.lizard.m_21824_();
        }
    }

    static class LizardAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Lizard lizard;

        public LizardAvoidEntityGoal(Lizard lizard, Class<T> class_, float f, double d, double e) {
            super((PathfinderMob)lizard, class_, f, d, e, EntitySelector.f_20406_::test);
            this.lizard = lizard;
        }

        public boolean m_8036_() {
            return !this.lizard.m_21824_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.lizard.m_21824_() && super.m_8045_();
        }
    }

    static class LizardMeleeAttackGoal
    extends MeleeAttackGoal {
        private final Lizard lizard;

        public LizardMeleeAttackGoal(Lizard lizard, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)lizard, speedModifier, followingTargetEvenIfNotSeen);
            this.lizard = lizard;
        }

        public boolean m_8036_() {
            return this.lizard.hasTail() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.lizard.hasTail() && super.m_8045_();
        }
    }
}

