/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistRegistry;
import com.starfish_studios.naturalist.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.registry.NaturalistTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Duck
extends Animal
implements IAnimatable {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(NaturalistTags.ItemTags.DUCK_FOOD_ITEMS);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private float nextFlap = 1.0f;
    public int eggTime;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public Duck(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.eggTime = this.f_19796_.m_188503_(6000) + 6000;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.m_6162_() ? dimensions.f_20378_ * 0.85f : dimensions.f_20378_ * 0.92f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public boolean m_6898_(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    protected float m_6108_() {
        return 0.9f;
    }

    @Nullable
    public Duck getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (Duck)NaturalistEntityTypes.DUCK.get().m_20615_((Level)serverLevel);
    }

    public static boolean checkDuckSpawnRules(EntityType<? extends Duck> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(NaturalistTags.BlockTags.SEMI_AQUATIC_SPAWNABLE_ON) || pLevel.m_8055_(pPos.m_7495_()).m_60819_().m_205070_(FluidTags.f_13131_);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_7755_().getString().equals("Ducky")) {
            return NaturalistSoundEvents.RUBBER_DUCKY_AMBIENT.get();
        }
        return NaturalistSoundEvents.DUCK_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_7755_().getString().equals("Ducky")) {
            return NaturalistSoundEvents.RUBBER_DUCKY_HURT.get();
        }
        return NaturalistSoundEvents.DUCK_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        if (this.m_7755_().getString().equals("Ducky")) {
            return NaturalistSoundEvents.RUBBER_DUCKY_DEATH.get();
        }
        return NaturalistSoundEvents.DUCK_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(NaturalistSoundEvents.DUCK_STEP.get(), 0.1f, 1.2f);
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            this.m_6858_(this.m_21566_().m_24999_() >= 1.2);
        } else {
            this.m_6858_(false);
            this.flapping = 0.9f;
        }
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.f_19861_ ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.f_19861_ && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.m_20184_();
        if (!this.f_19861_ && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
        if (!this.f_19853_.f_46443_ && this.m_6084_() && !this.m_6162_() && --this.eggTime <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)NaturalistRegistry.DUCK_EGG.get());
            this.m_146850_(GameEvent.f_157810_);
            this.eggTime = this.f_19796_.m_188503_(6000) + 6000;
        }
    }

    public int m_213860_() {
        return 10;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("EggLayTime")) {
            this.eggTime = compound.m_128451_("EggLayTime");
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("EggLayTime", this.eggTime);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("swim"));
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            if (this.m_20142_()) {
                event.getController().setAnimation(new AnimationBuilder().loop("walk"));
                event.getController().setAnimationSpeed(2.0);
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().loop("walk"));
            event.getController().setAnimationSpeed(1.5);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().loop("idle"));
        event.getController().setAnimationSpeed(1.0);
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState flapPredicate(AnimationEvent<E> event) {
        if (!this.f_19861_ && !this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("flap"));
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState hurtPredicate(AnimationEvent<E> event) {
        if (this.f_20916_ > 0) {
            event.getController().setAnimation(new AnimationBuilder().loop("hurt"));
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(10.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "flapController", 4.0f, this::flapPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "hurtController", 4.0f, this::hurtPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

