/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import commoble.morered.MoreRed;
import commoble.morered.plate_blocks.InputState;
import commoble.morered.plate_blocks.LatchBlock;
import commoble.morered.plate_blocks.LogicFunction;
import commoble.morered.plate_blocks.LogicFunctions;
import commoble.morered.wire_post.AbstractPoweredWirePostBlock;
import commoble.morered.wire_post.WirePostBlock;
import commoble.morered.wires.Edge;
import commoble.morered.wires.WireBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ColorHandlers {
    public static final int NO_TINT = 0xFFFFFF;
    public static final int LIT = 0xFFFFFF;
    public static final int UNLIT = 0x560000;
    public static final int LIT_RED = 255;
    public static final int UNLIT_RED = 86;

    public static int getLogicFunctionBlockTint(BlockState state, BlockAndTintGetter lightReader, BlockPos pos, int tintIndex) {
        return ColorHandlers.getLogicFunctionBlockStateTint(state, tintIndex);
    }

    public static int getLogicFunctionBlockStateTint(BlockState state, int tintIndex) {
        InputState input = InputState.getInput(state);
        return ColorHandlers.getLogicFunctionTint(tintIndex, input.a, input.b, input.c);
    }

    public static int getLogicFunctionBlockItemTint(ItemStack stack, int tintIndex) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            return ColorHandlers.getLogicFunctionBlockStateTint(((BlockItem)item).m_40614_().m_49966_(), tintIndex);
        }
        return 0xFFFFFF;
    }

    public static int getLogicFunctionTint(int tintIndex, boolean a, boolean b, boolean c) {
        if (tintIndex < 1) {
            return 0xFFFFFF;
        }
        LogicFunction logicFunction = (LogicFunction)LogicFunctions.TINTINDEXES.getOrDefault(tintIndex, (Object)LogicFunctions.FALSE);
        return logicFunction.apply(a, b, c) ? 0xFFFFFF : 0x560000;
    }

    public static int getLatchBlockTint(BlockState state, BlockAndTintGetter lightReader, BlockPos pos, int tintIndex) {
        return ColorHandlers.getLatchTint(state, tintIndex);
    }

    public static int getLatchItemTint(ItemStack stack, int tintIndex) {
        return ColorHandlers.getLatchTint(((LatchBlock)((Object)MoreRed.instance().latchBlock.get())).m_49966_(), tintIndex);
    }

    public static int getLatchTint(BlockState state, int tintIndex) {
        if (tintIndex == 18) {
            return (Boolean)state.m_61143_((Property)LatchBlock.POWERED) != false && (Boolean)state.m_61143_((Property)LatchBlock.INPUT_C) == false ? 0xFFFFFF : 0x560000;
        }
        if (tintIndex == 19) {
            return (Boolean)state.m_61143_((Property)LatchBlock.POWERED) == false && (Boolean)state.m_61143_((Property)LatchBlock.INPUT_A) == false ? 0xFFFFFF : 0x560000;
        }
        InputState input = InputState.getInput(state);
        return ColorHandlers.getLogicFunctionTint(tintIndex, input.a, input.b, input.c);
    }

    public static int getRedwirePostBlockTint(BlockState state, BlockAndTintGetter lightReader, BlockPos pos, int tintIndex) {
        return ColorHandlers.getRedwirePostTint(state, tintIndex);
    }

    public static int getRedwirePostItemTint(ItemStack stack, int tintIndex) {
        return ColorHandlers.getRedwirePostTint(((WirePostBlock)((Object)MoreRed.instance().redwirePostBlock.get())).m_49966_(), tintIndex);
    }

    public static int getRedwirePostTint(BlockState state, int tintIndex) {
        if (tintIndex == 1) {
            int power = (Integer)state.m_61143_((Property)AbstractPoweredWirePostBlock.POWER);
            double lerpFactor = (double)power / 15.0;
            return (int)Mth.m_14139_((double)lerpFactor, (double)86.0, (double)255.0) << 16;
        }
        return 0xFFFFFF;
    }

    public static int getRedAlloyWireBlockTint(BlockState state, BlockAndTintGetter world, BlockPos pos, int tintIndex) {
        if (tintIndex < 0 || tintIndex > 18) {
            return 0xFFFFFF;
        }
        if (tintIndex == 0) {
            return 0x560000;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof WireBlockEntity) {
            WireBlockEntity wire = (WireBlockEntity)te;
            if (tintIndex < 7) {
                int side = tintIndex - 1;
                int power = wire.getPower(side);
                double lerpFactor = (double)power / 32.0;
                return (int)Mth.m_14139_((double)lerpFactor, (double)86.0, (double)255.0) << 16;
            }
            int edgeIndex = tintIndex - 7;
            Edge edge = Edge.values()[edgeIndex];
            Direction directionA = edge.sideA;
            BlockPos neighborPosA = pos.m_121945_(directionA);
            BlockEntity neighborTileA = world.m_7702_(neighborPosA);
            if (neighborTileA instanceof WireBlockEntity) {
                WireBlockEntity neighborWireA = (WireBlockEntity)neighborTileA;
                Direction directionB = edge.sideB;
                BlockPos neighborPosB = pos.m_121945_(directionB);
                BlockEntity neighborTileB = world.m_7702_(neighborPosB);
                if (neighborTileB instanceof WireBlockEntity) {
                    WireBlockEntity neighborWireB = (WireBlockEntity)neighborTileB;
                    double powerA = neighborWireA.getPower(directionB);
                    double powerB = neighborWireB.getPower(directionA);
                    double averagePower = (powerA + powerB) / 2.0;
                    double lerpFactor = averagePower / 32.0;
                    return (int)Mth.m_14139_((double)lerpFactor, (double)86.0, (double)255.0) << 16;
                }
            }
        }
        return 0xFFFFFF;
    }

    public static int getRedAlloyWireItemTint(ItemStack stack, int tintIndex) {
        return tintIndex >= 0 ? 0x560000 : 0xFFFFFF;
    }
}

