/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import com.google.common.collect.ImmutableSet;
import commoble.morered.wire_post.PostsInChunk;
import commoble.morered.wires.AbstractWireBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;

public class ClientProxy {
    private static final Set<BlockPos> NO_POSTS = ImmutableSet.of();
    private static Map<ChunkPos, Set<BlockPos>> clientPostsInChunk = new HashMap<ChunkPos, Set<BlockPos>>();

    public static void clear() {
        clientPostsInChunk = new HashMap<ChunkPos, Set<BlockPos>>();
    }

    public static void updatePostsInChunk(ChunkPos pos, Set<BlockPos> posts) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        LevelChunk chunk = level.m_6325_(pos.f_45578_, pos.f_45579_);
        if (chunk == null) {
            return;
        }
        chunk.getCapability(PostsInChunk.CAPABILITY).ifPresent(cap -> cap.setPositions(Set.copyOf(posts)));
    }

    @Nonnull
    public static Set<BlockPos> getPostsInChunk(ChunkPos pos) {
        return clientPostsInChunk.getOrDefault(pos, NO_POSTS);
    }

    public static void initializeAbstractWireBlockClient(final AbstractWireBlock block, Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level Level2, HitResult target, ParticleEngine manager) {
                return block.getWireCount(state) == 0;
            }
        });
    }
}

