/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.api.internal;

import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.ExpandedPowerSupplier;
import commoble.morered.api.WireConnector;
import commoble.morered.api.internal.WireVoxelHelpers;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DefaultWireProperties {
    public static final VoxelShape[] SMALL_NODE_SHAPES = WireVoxelHelpers.makeNodeShapes(1, 2);
    public static final WireConnector DEFAULT_WIRE_CONNECTOR = DefaultWireProperties::canGenericBlockConnectToWire;
    public static final ExpandedPowerSupplier DEFAULT_EXPANDED_POWER_SUPPLIER = DefaultWireProperties::getDefaultExpandedPower;
    public static final WireConnector DEFAULT_CABLE_CONNECTOR = DefaultWireProperties::canGenericBlockConnectToCable;
    public static final ChanneledPowerSupplier NO_POWER_SUPPLIER = (theWorld, pos, state, face, channel) -> 0;

    private static boolean canGenericBlockConnectToWire(BlockGetter world, BlockPos thisNeighborPos, BlockState thisNeighborState, BlockPos wirePos, BlockState wireState, Direction wireFace, Direction directionToWire) {
        Block neighborBlock = thisNeighborState.m_60734_();
        if (neighborBlock instanceof LeverBlock || neighborBlock instanceof ButtonBlock) {
            AttachFace attachFace = (AttachFace)thisNeighborState.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_);
            return attachFace == AttachFace.FLOOR && wireFace == Direction.DOWN || attachFace == AttachFace.CEILING && wireFace == Direction.UP || attachFace == AttachFace.WALL && ((Direction)thisNeighborState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_() == wireFace;
        }
        if (thisNeighborState.m_204336_(BlockTags.f_13099_)) {
            return wireFace == Direction.DOWN;
        }
        if (!thisNeighborState.canRedstoneConnectTo(world, wirePos, directionToWire.m_122424_())) {
            return false;
        }
        VoxelShape wireTestShape = SMALL_NODE_SHAPES[wireFace.ordinal()];
        VoxelShape neighborShape = thisNeighborState.m_60816_(world, thisNeighborPos);
        VoxelShape projectedNeighborShape = neighborShape.m_83263_(directionToWire);
        return !Shapes.m_83157_((VoxelShape)projectedNeighborShape, (VoxelShape)wireTestShape, (BooleanOp)BooleanOp.f_82683_);
    }

    public static boolean isRedstoneWireConnectable(BlockGetter world, BlockPos redstonePos, BlockState redstoneState, BlockPos wirePos, BlockState wireState, Direction wireFace, Direction directionToWire) {
        return wireFace == Direction.DOWN && directionToWire.m_122434_() != Direction.Axis.Y;
    }

    private static int getDefaultExpandedPower(@Nonnull Level world, @Nonnull BlockPos thisPos, @Nonnull BlockState thisState, @Nonnull BlockPos wirePos, @Nonnull BlockState wireState, @Nonnull Direction wireFace, @Nonnull Direction directionToThis) {
        return thisState.m_60746_((BlockGetter)world, thisPos, directionToThis) * 2;
    }

    private static boolean canGenericBlockConnectToCable(BlockGetter world, BlockPos thisPos, BlockState thisState, BlockPos wirePos, BlockState wireState, Direction wireFace, Direction directionToWire) {
        return false;
    }
}

