/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;

public class ImageTransformer {
    protected final int originalW;
    protected final int originalH;
    protected final int targetW;
    protected final int targetH;
    private final List<Tpos> transforms;

    public void apply(TextureImage original, TextureImage target) {
        int actualOrW = original.frameWidth();
        int actualOrH = original.frameHeight();
        int actualTarW = target.frameHeight();
        int actualTarH = target.frameHeight();
        NativeImage orIm = original.getImage();
        for (Tpos tr : this.transforms) {
            Tpos t = tr.scaled(actualOrW, actualOrH, actualTarW, actualTarH, this.originalW, this.originalH, this.targetW, this.targetH);
            original.forEachFrame((frameIndex, globalX, globalY) -> {
                int frameX = globalX - original.getFrameX(frameIndex);
                int frameY = globalY - original.getFrameX(frameIndex);
                if (frameX >= t.startX() && frameX < t.maxX() && frameY >= t.startY() && frameY < t.maxY()) {
                    int col = orIm.m_84985_(globalX.intValue(), globalY.intValue());
                    int targetX = t.targetX + frameX - t.startX();
                    int targetY = t.targetY + frameY - t.startY();
                    if (targetX < actualTarW && targetY < actualTarH) {
                        target.setFramePixel(frameIndex, targetX, targetY, col);
                    }
                }
            });
        }
    }

    private ImageTransformer(int originalW, int originalH, int targetW, int targetH, List<Tpos> list) {
        this.originalW = originalW;
        this.originalH = originalH;
        this.targetW = targetW;
        this.targetH = targetH;
        this.transforms = list;
    }

    public static Builder builder(int originalW, int originalH, int targetW, int targetH) {
        return new Builder(originalW, originalH, targetW, targetH);
    }

    private record Tpos(int startX, int startY, int width, int height, int targetX, int targetY) {
        public Tpos scaled(int aOW, int aOH, int aTW, int aTH, int oW, int oH, int tW, int tH) {
            float scaleOW = (float)aOW / (float)oW;
            float scaleOH = (float)aOH / (float)oH;
            float scaleTW = (float)aTW / (float)tW;
            float scaleTH = (float)aTH / (float)tH;
            return new Tpos((int)(scaleOW * (float)this.startX), (int)(scaleOH * (float)this.startY), (int)(scaleOW * (float)this.width), (int)(scaleOH * (float)this.height), (int)(scaleTW * (float)this.targetX), (int)(scaleTH * (float)this.targetY));
        }

        public int maxX() {
            return this.startX + this.width;
        }

        public int maxY() {
            return this.startY + this.height;
        }
    }

    public static class Builder {
        protected final int originalW;
        protected final int originalH;
        protected final int targetW;
        protected final int targetH;
        private final List<Tpos> transforms = new ArrayList<Tpos>();

        protected Builder(int originalW, int originalH, int targetW, int targetH) {
            this.originalW = originalW;
            this.originalH = originalH;
            this.targetW = targetW;
            this.targetH = targetH;
        }

        public Builder copyRect(int startX, int startY, int width, int height, int targetX, int targetY) {
            Preconditions.checkArgument((startX + width <= this.originalW ? 1 : 0) != 0, (Object)"Invalid dimensions: original width");
            Preconditions.checkArgument((startY + height <= this.originalH ? 1 : 0) != 0, (Object)"Invalid dimensions: original height");
            Preconditions.checkArgument((targetX <= this.targetW ? 1 : 0) != 0, (Object)"Invalid dimensions: target width");
            Preconditions.checkArgument((targetY <= this.targetH ? 1 : 0) != 0, (Object)"Invalid dimensions: target height");
            this.transforms.add(new Tpos(startX, startY, width, height, targetX, targetY));
            return this;
        }

        public ImageTransformer build() {
            return new ImageTransformer(this.originalW, this.originalH, this.targetW, this.targetH, this.transforms.stream().toList());
        }
    }
}

