/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BeamData;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CompiledSenderModule1
extends CompiledModule {
    public CompiledSenderModule1(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        PositionedItemHandler positionedItemHandler;
        IItemHandler buffer = router.getBuffer();
        ItemStack bufferStack = buffer.getStackInSlot(0);
        if (this.getFilter().test(bufferStack) && (positionedItemHandler = this.findTargetInventory(router)).isValid()) {
            int sent;
            int nToSend = this.getItemsPerTick(router);
            if (this.getRegulationAmount() > 0) {
                int existing = InventoryUtils.countItems(bufferStack, positionedItemHandler.handler, this.getRegulationAmount(), !this.getFilter().getFlags().isIgnoreDamage());
                if ((nToSend = Math.min(nToSend, this.getRegulationAmount() - existing)) <= 0) {
                    return false;
                }
            }
            if ((sent = InventoryUtils.transferItems(buffer, positionedItemHandler.handler, 0, nToSend)) > 0) {
                if (((Boolean)ConfigHolder.common.module.senderParticles.get()).booleanValue()) {
                    this.playParticles(router, positionedItemHandler.pos, ItemHandlerHelper.copyStackWithSize((ItemStack)bufferStack, (int)sent));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    void playParticles(ModularRouterBlockEntity router, BlockPos targetPos, ItemStack stack) {
        if (router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) < 2) {
            router.addItemBeam(new BeamData(router.getTickRate(), targetPos, stack, this.getBeamColor()));
        }
    }

    protected int getBeamColor() {
        return 0xFFC000;
    }

    PositionedItemHandler findTargetInventory(ModularRouterBlockEntity router) {
        ModuleTarget target = this.getEffectiveTarget(router);
        if (target != null) {
            return target.getItemHandler().map(h -> new PositionedItemHandler(target.gPos.m_122646_(), (IItemHandler)h)).orElse(PositionedItemHandler.INVALID);
        }
        return PositionedItemHandler.INVALID;
    }

    @Override
    public ModuleTarget getEffectiveTarget(ModularRouterBlockEntity router) {
        BlockPos p0 = this.getTarget().gPos.m_122646_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(p0.m_123341_(), p0.m_123342_(), p0.m_123343_());
        Direction face = this.getTarget().face;
        Level level = router.nonNullLevel();
        for (int i = 1; i <= this.getRange(); ++i) {
            BlockEntity te = level.m_7702_((BlockPos)pos);
            if (te != null && te.getCapability(ForgeCapabilities.ITEM_HANDLER, this.getTarget().face).isPresent()) {
                GlobalPos gPos = MiscUtil.makeGlobalPos(level, pos.m_7949_());
                return new ModuleTarget(gPos, face, BlockUtil.getBlockName(level, (BlockPos)pos));
            }
            if (!this.isPassable(level, (BlockPos)pos, face)) {
                return null;
            }
            pos.m_122173_(this.getFacing());
        }
        return null;
    }

    private boolean isPassable(Level w, BlockPos pos, Direction face) {
        BlockState state = w.m_8055_(pos);
        return !MiscUtil.blockHasSolidSide(state, (BlockGetter)w, pos, face.m_122424_()) || !state.m_60804_((BlockGetter)w, pos);
    }

    record PositionedItemHandler(BlockPos pos, IItemHandler handler) {
        static final PositionedItemHandler INVALID = new PositionedItemHandler(null, null);

        boolean isValid() {
            return this.pos != null && this.handler != null;
        }
    }
}

