/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.relocated.commonmark.node;

import com.klikli_dev.relocated.commonmark.node.Node;
import java.util.Iterator;

public class Nodes {
    private Nodes() {
    }

    public static Iterable<Node> between(Node start, Node end) {
        return new NodeIterable(start.getNext(), end);
    }

    private static class NodeIterator
    implements Iterator<Node> {
        private Node node;
        private final Node end;

        private NodeIterator(Node first, Node end) {
            this.node = first;
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.node != null && this.node != this.end;
        }

        @Override
        public Node next() {
            Node result = this.node;
            this.node = this.node.getNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class NodeIterable
    implements Iterable<Node> {
        private final Node first;
        private final Node end;

        private NodeIterable(Node first, Node end) {
            this.first = first;
            this.end = end;
        }

        @Override
        public Iterator<Node> iterator() {
            return new NodeIterator(this.first, this.end);
        }
    }
}

