/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.relocated.commonmark.internal;

import com.klikli_dev.relocated.commonmark.internal.LinkReferenceDefinitionParser;
import com.klikli_dev.relocated.commonmark.node.Block;
import com.klikli_dev.relocated.commonmark.node.LinkReferenceDefinition;
import com.klikli_dev.relocated.commonmark.node.Paragraph;
import com.klikli_dev.relocated.commonmark.node.SourceSpan;
import com.klikli_dev.relocated.commonmark.parser.InlineParser;
import com.klikli_dev.relocated.commonmark.parser.SourceLine;
import com.klikli_dev.relocated.commonmark.parser.SourceLines;
import com.klikli_dev.relocated.commonmark.parser.block.AbstractBlockParser;
import com.klikli_dev.relocated.commonmark.parser.block.BlockContinue;
import com.klikli_dev.relocated.commonmark.parser.block.ParserState;
import java.util.List;

public class ParagraphParser
extends AbstractBlockParser {
    private final Paragraph block = new Paragraph();
    private final LinkReferenceDefinitionParser linkReferenceDefinitionParser = new LinkReferenceDefinitionParser();

    @Override
    public boolean canHaveLazyContinuationLines() {
        return true;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (!state.isBlank()) {
            return BlockContinue.atIndex(state.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine line) {
        this.linkReferenceDefinitionParser.parse(line);
    }

    @Override
    public void addSourceSpan(SourceSpan sourceSpan) {
        this.linkReferenceDefinitionParser.addSourceSpan(sourceSpan);
    }

    @Override
    public void closeBlock() {
        if (this.linkReferenceDefinitionParser.getParagraphLines().isEmpty()) {
            this.block.unlink();
        } else {
            this.block.setSourceSpans(this.linkReferenceDefinitionParser.getParagraphSourceSpans());
        }
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        SourceLines lines = this.linkReferenceDefinitionParser.getParagraphLines();
        if (!lines.isEmpty()) {
            inlineParser.parse(lines, this.block);
        }
    }

    public SourceLines getParagraphLines() {
        return this.linkReferenceDefinitionParser.getParagraphLines();
    }

    public List<LinkReferenceDefinition> getDefinitions() {
        return this.linkReferenceDefinitionParser.getDefinitions();
    }
}

