/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.network.packets;

import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketDurabilitySync {
    private final List<Tuple<BlockPos, Integer>> updateList;

    public PacketDurabilitySync(List<Tuple<BlockPos, Integer>> updateList) {
        this.updateList = updateList;
    }

    public static void encode(PacketDurabilitySync msg, FriendlyByteBuf buffer) {
        List<Tuple<BlockPos, Integer>> thisList = msg.updateList;
        CompoundTag tag = new CompoundTag();
        ListTag nbtList = new ListTag();
        for (int i = 0; i < thisList.size(); ++i) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)thisList.get(i).m_14418_())));
            nbt.m_128405_("dur", ((Integer)thisList.get(i).m_14419_()).intValue());
            nbtList.add(i, (Tag)nbt);
        }
        tag.m_128365_("list", (Tag)nbtList);
        buffer.m_130079_(tag);
    }

    public static PacketDurabilitySync decode(FriendlyByteBuf buffer) {
        CompoundTag tag = buffer.m_130260_();
        ListTag nbtList = tag.m_128437_("list", 10);
        ArrayList<Tuple<BlockPos, Integer>> thisList = new ArrayList<Tuple<BlockPos, Integer>>();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbt = nbtList.m_128728_(i);
            thisList.add((Tuple<BlockPos, Integer>)new Tuple((Object)NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("pos")), (Object)nbt.m_128451_("dur")));
        }
        return new PacketDurabilitySync(thisList);
    }

    public static void clientPacketHandler(PacketDurabilitySync msg) {
        List<Tuple<BlockPos, Integer>> thisList = msg.updateList;
        for (int i = 0; i < thisList.size(); ++i) {
            BlockPos pos = (BlockPos)thisList.get(i).m_14418_();
            int durability = (Integer)thisList.get(i).m_14419_();
            BlockEntity clientTE = Minecraft.m_91087_().f_91073_.m_7702_(pos);
            if (!(clientTE instanceof RenderBlockTileEntity)) {
                return;
            }
            ((RenderBlockTileEntity)clientTE).setClientDurability(durability);
        }
    }

    public static class Handler {
        public static void handle(PacketDurabilitySync msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketDurabilitySync.clientPacketHandler(msg)));
            ctx.get().setPacketHandled(true);
        }
    }
}

