/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;

public class SchemFixerUtil {
    public static void fixSchematics() {
        String baseFolder = Paths.get("", new String[0]).toAbsolutePath().getParent().toString() + "/src/main/resources/assets/minecolonies/schematics";
        File baseFolderFile = new File(baseFolder);
        List<File> files = Arrays.asList(baseFolderFile.listFiles());
        for (File subFolder : files) {
            File[] subFileArray = subFolder.listFiles();
            if (subFileArray == null) continue;
            List<File> subFiles = Arrays.asList(subFileArray);
            for (File blueprintFile : subFiles) {
                if (!blueprintFile.exists() || !blueprintFile.getName().contains("blueprint")) continue;
                try {
                    if (blueprintFile.getName().startsWith("home")) {
                        com.google.common.io.Files.move((File)blueprintFile, (File)new File(blueprintFile.getPath().substring(0, blueprintFile.getPath().lastIndexOf("/") + 1) + blueprintFile.getName().replace("home", "residence")));
                        continue;
                    }
                    if (!blueprintFile.getName().startsWith("citizen")) continue;
                    com.google.common.io.Files.move((File)blueprintFile, (File)new File(blueprintFile.getPath().substring(0, blueprintFile.getPath().lastIndexOf("/") + 1) + blueprintFile.getName().replace("citizen", "residence")));
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Failed rename.", (Throwable)ex);
                }
            }
        }
        List<File> followFiles = Arrays.asList(baseFolderFile.listFiles());
        for (File subFolder : followFiles) {
            File[] subFileArray = subFolder.listFiles();
            if (subFileArray == null) continue;
            List<File> subFiles = Arrays.asList(subFileArray);
            for (File blueprintFile : subFiles) {
                if (!blueprintFile.exists() || !blueprintFile.getName().contains("blueprint")) continue;
                try {
                    CompoundTag compoundNBT = NbtIo.m_128939_((InputStream)new ByteArrayInputStream(Files.readAllBytes(blueprintFile.toPath())));
                    Blueprint blueprint = BlueprintUtil.readBlueprintFromNBT((CompoundTag)compoundNBT);
                    if (!SchemFixerUtil.fixSchematicNameAndCorners(blueprint)) continue;
                    BlueprintUtil.writeToStream((OutputStream)new FileOutputStream(blueprintFile), (Blueprint)blueprint);
                }
                catch (Exception e) {
                    Log.getLogger().warn("Could not read file:" + subFolder.getName() + ":" + blueprintFile.getName());
                }
            }
        }
    }

    private static boolean fixSchematicNameAndCorners(Blueprint blueprint) {
        boolean changed = false;
        CompoundTag compoundNBT = ((BlockInfo)blueprint.getBlockInfoAsMap().get(blueprint.getPrimaryBlockOffset())).getTileEntityData();
        if (compoundNBT == null) {
            BlockPos original = blueprint.getPrimaryBlockOffset();
            blueprint.setCachePrimaryOffset(null);
            BlockPos autoPos = blueprint.getPrimaryBlockOffset();
            blueprint.setCachePrimaryOffset(original);
            compoundNBT = ((BlockInfo)blueprint.getBlockInfoAsMap().get(autoPos)).getTileEntityData();
            if (compoundNBT != null && compoundNBT.m_128441_("blueprintDataProvider")) {
                blueprint.setCachePrimaryOffset(autoPos);
                Log.getLogger().warn("Fixing blueprint schematic anchor for:" + blueprint.getName());
                changed = true;
            }
        }
        if (compoundNBT != null && compoundNBT.m_128441_("blueprintDataProvider")) {
            CompoundTag schemDataCompound = (CompoundTag)compoundNBT.m_128423_("blueprintDataProvider");
            String name = schemDataCompound.m_128461_("schematicName");
            if (name.contains("citizen") || name.contains("home")) {
                blueprint.setName(blueprint.getName().replace("home", "residence"));
                blueprint.setName(blueprint.getName().replace("citizen", "residence"));
            }
            if (!name.equals(blueprint.getName())) {
                schemDataCompound.m_128359_("schematicName", blueprint.getName());
                BlockPosUtil.writeToNBT((CompoundTag)schemDataCompound, (String)"corner1", (BlockPos)BlockPos.f_121853_.m_121996_((Vec3i)blueprint.getPrimaryBlockOffset()));
                BlockPosUtil.writeToNBT((CompoundTag)schemDataCompound, (String)"corner2", (BlockPos)new BlockPos(blueprint.getSizeX() - 1, blueprint.getSizeY() - 1, blueprint.getSizeZ() - 1).m_121996_((Vec3i)blueprint.getPrimaryBlockOffset()));
                Log.getLogger().warn("Fixing blueprint schematic name and corners for:" + blueprint.getName());
                return true;
            }
        }
        return changed;
    }
}

