/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.effects.ModResearchEffects;
import com.minecolonies.api.research.effects.registry.ResearchEffectEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GlobalResearchEffect
implements IResearchEffect<Double> {
    private static final String TAG_ID = "id";
    private static final String TAG_DESC = "desc";
    private static final String TAG_SUBTITLE = "subtitle";
    private static final String TAG_EFFECT = "effect";
    private static final String TAG_DISPLAY_EFFECT = "display";
    private double effect;
    private final double displayEffect;
    private final ResourceLocation id;
    private final TranslatableContents desc;
    private final TranslatableContents subtitle;

    public GlobalResearchEffect(ResourceLocation id, double effect, double displayEffect) {
        this.id = id;
        this.effect = effect;
        this.displayEffect = displayEffect;
        this.desc = new TranslatableContents("com." + this.id.m_135827_() + ".research." + this.id.m_135815_().replaceAll("[ /:]", ".") + ".description", new Object[]{displayEffect, effect, Math.round(displayEffect * 100.0), Math.round(effect * 100.0)});
        this.subtitle = new TranslatableContents("");
    }

    public GlobalResearchEffect(ResourceLocation id, double effect, double displayEffect, TranslatableContents desc, TranslatableContents subtitle) {
        this.id = id;
        this.effect = effect;
        this.displayEffect = displayEffect;
        String key = desc.m_237508_();
        this.desc = key.isEmpty() ? new TranslatableContents("com." + this.id.m_135815_() + ".research." + this.id.m_135827_().replaceAll("[ /:]", ".") + ".description", new Object[]{displayEffect, effect, Math.round(displayEffect * 100.0), Math.round(effect * 100.0)}) : new TranslatableContents(key, new Object[]{displayEffect, effect, Math.round(displayEffect * 100.0), Math.round(effect * 100.0)});
        this.subtitle = subtitle;
    }

    public GlobalResearchEffect(CompoundTag nbt) {
        this.id = new ResourceLocation(nbt.m_128461_(TAG_ID));
        this.effect = nbt.m_128459_(TAG_EFFECT);
        this.displayEffect = nbt.m_128459_(TAG_DISPLAY_EFFECT);
        this.desc = new TranslatableContents(nbt.m_128461_(TAG_DESC), new Object[]{this.displayEffect, this.effect, Math.round(this.displayEffect * 100.0), Math.round(this.effect * 100.0)});
        this.subtitle = new TranslatableContents(nbt.m_128461_(TAG_SUBTITLE));
    }

    @Override
    public Double getEffect() {
        return this.effect;
    }

    @Override
    public void setEffect(Double effect) {
        this.effect = effect;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public TranslatableContents getDesc() {
        return this.desc;
    }

    @Override
    public TranslatableContents getSubtitle() {
        return this.subtitle;
    }

    @Override
    public boolean overrides(@NotNull IResearchEffect<?> other) {
        return Math.abs(this.effect) > Math.abs(((GlobalResearchEffect)other).effect);
    }

    @Override
    public ResearchEffectEntry getRegistryEntry() {
        return (ResearchEffectEntry)ModResearchEffects.globalResearchEffect.get();
    }

    @Override
    public CompoundTag writeToNBT() {
        String descKey = this.desc.m_237508_();
        String subtitleKey = this.subtitle.m_237508_();
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(TAG_ID, this.id.toString());
        nbt.m_128359_(TAG_DESC, descKey);
        nbt.m_128359_(TAG_SUBTITLE, subtitleKey);
        nbt.m_128347_(TAG_EFFECT, this.effect);
        nbt.m_128347_(TAG_DISPLAY_EFFECT, this.displayEffect);
        return nbt;
    }
}

