/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.quests.rewards;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.happiness.ExpirationBasedHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.StaticHappinessSupplier;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestRewardTemplate;
import com.minecolonies.coremod.colony.CitizenData;
import net.minecraft.world.entity.player.Player;

public class HappinessRewardTemplate
implements IQuestRewardTemplate {
    private final int qty;
    private final int days;
    private final int target;

    public HappinessRewardTemplate(int target, int qty, int days) {
        this.target = target;
        this.qty = qty;
        this.days = days;
    }

    public static IQuestRewardTemplate createReward(JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int target = details.get("target").getAsInt();
        int qty = details.get("qty").getAsInt();
        int days = details.get("days").getAsInt();
        return new HappinessRewardTemplate(target, qty, days);
    }

    @Override
    public void applyReward(IColony colony, Player player, IQuestInstance colonyQuest) {
        if (this.target == 0) {
            ((CitizenData)colonyQuest.getQuestGiver()).getCitizenHappinessHandler().addModifier(new ExpirationBasedHappinessModifier("quest", 2.0, new StaticHappinessSupplier(this.qty), this.days));
        } else {
            ((CitizenData)colonyQuest.getParticipant(this.target)).getCitizenHappinessHandler().addModifier(new ExpirationBasedHappinessModifier("quest", 2.0, new StaticHappinessSupplier(this.qty), this.days));
        }
    }
}

