/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.research.IResearchManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewResearchManagerViewMessage
implements IMessage {
    private int colonyId;
    private FriendlyByteBuf researchManagerData;
    private ResourceKey<Level> dimension;

    public ColonyViewResearchManagerViewMessage() {
    }

    public ColonyViewResearchManagerViewMessage(IColony colony, @NotNull IResearchManager researchManager) {
        this.colonyId = colony.getID();
        this.dimension = colony.getDimension();
        this.researchManagerData = new FriendlyByteBuf(Unpooled.buffer());
        CompoundTag researchCompound = new CompoundTag();
        researchManager.writeToNBT(researchCompound);
        this.researchManagerData.m_130079_(researchCompound);
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.researchManagerData = new FriendlyByteBuf(Unpooled.buffer((int)buf.readableBytes()));
        buf.readBytes((ByteBuf)this.researchManagerData, buf.readableBytes());
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        this.researchManagerData.resetReaderIndex();
        buf.writeInt(this.colonyId);
        buf.m_130070_(this.dimension.m_135782_().toString());
        buf.writeBytes((ByteBuf)this.researchManagerData);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (colonyView != null) {
            colonyView.handleColonyViewResearchManagerUpdate(this.researchManagerData.m_130260_());
        }
    }
}

