/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.minecolonies.api.items.CheckedNbtKey;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.Log;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ItemNbtCalculator
implements DataProvider {
    private final DataGenerator generator;

    public ItemNbtCalculator(DataGenerator generator) {
        this.generator = generator;
    }

    @NotNull
    public String m_6055_() {
        return "ItemNBTCalculator";
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        for (Item theItem : ForgeRegistries.ITEMS.getValues()) {
            NonNullList list = NonNullList.m_122779_();
            try {
                theItem.m_6787_(CreativeModeTab.f_40754_, list);
            }
            catch (Exception e) {
                Log.getLogger().warn("Error populating items for " + ForgeRegistries.ITEMS.getKey((Object)theItem) + "; using fallback", (Throwable)e);
                list.add((Object)new ItemStack((ItemLike)theItem));
            }
            Iterator e = list.iterator();
            while (e.hasNext()) {
                BlockItem blockItem;
                ItemStack item = (ItemStack)e.next();
                Item item2 = item.m_41720_();
                if (item2 instanceof BlockItem && (item2 = (blockItem = (BlockItem)item2).m_40614_()) instanceof IMateriallyTexturedBlock) {
                    IMateriallyTexturedBlock texturedBlock = (IMateriallyTexturedBlock)item2;
                    CompoundTag tag = item.m_41782_() ? item.m_41783_() : new CompoundTag();
                    CompoundTag textureData = new CompoundTag();
                    for (IMateriallyTexturedBlockComponent key2 : texturedBlock.getComponents()) {
                        textureData.m_128359_(key2.getId().toString(), key2.getDefault().m_204297_().m_205785_().m_135782_().toString());
                    }
                    tag.m_128365_("textureData", (Tag)textureData);
                    ItemStack copy = item.m_41777_();
                    copy.m_41751_(tag);
                    listBuilder.add((Object)copy);
                    continue;
                }
                listBuilder.add((Object)item);
            }
        }
        ImmutableList allStacks = listBuilder.build();
        TreeMap<String, Set> keyMapping = new TreeMap<String, Set>();
        for (ItemStack stack : allStacks) {
            HashSet<String> keys;
            ResourceLocation resourceLocation = ((ResourceKey)stack.m_220173_().m_203543_().get()).m_135782_();
            CompoundTag tag = stack.m_41782_() && !stack.m_204117_(ModTags.ignoreNBT) ? stack.m_41783_() : new CompoundTag();
            HashSet<String> hashSet = keys = tag.m_128456_() ? new HashSet<String>() : new HashSet(tag.m_128431_());
            if (stack.m_41792_()) {
                keys.add("Enchantments");
            }
            if (stack.isRepairable()) {
                keys.add("RepairCost");
            }
            keys.remove("Damage");
            HashSet<CheckedNbtKey> keyObjectList = new HashSet<CheckedNbtKey>();
            for (String key3 : keys) {
                keyObjectList.add(ItemNbtCalculator.createKeyFromNbt(key3, tag));
            }
            if (keyMapping.containsKey(resourceLocation.toString())) {
                Set list = (Set)keyMapping.get(resourceLocation.toString());
                list.addAll(keyObjectList);
                keyMapping.put(resourceLocation.toString(), list);
                continue;
            }
            keyMapping.put(resourceLocation.toString(), keyObjectList);
        }
        Path path = this.generator.m_236036_(DataGenerator.Target.DATA_PACK, "compatibility").m_236050_(new ResourceLocation("minecolonies", "itemnbtmatching"), "json");
        JsonArray jsonArray = new JsonArray();
        for (Map.Entry entry : keyMapping.entrySet()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", (String)entry.getKey());
            if (!((Set)entry.getValue()).isEmpty()) {
                JsonArray subArray = new JsonArray();
                ((Set)entry.getValue()).forEach(key -> subArray.add((JsonElement)ItemNbtCalculator.serializeKeyToJson(key)));
                jsonObject.add("checkednbtkeys", (JsonElement)subArray);
            }
            jsonArray.add((JsonElement)jsonObject);
        }
        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)jsonArray, (Path)path);
    }

    public static JsonObject serializeKeyToJson(CheckedNbtKey keyObject) {
        JsonObject obj = new JsonObject();
        obj.addProperty("key", keyObject.key);
        if (!keyObject.children.isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            keyObject.children.forEach(child -> jsonArray.add((JsonElement)ItemNbtCalculator.serializeKeyToJson(child)));
            obj.add("children", (JsonElement)jsonArray);
        }
        return obj;
    }

    public static CheckedNbtKey createKeyFromNbt(String key, CompoundTag tag) {
        if (tag.m_128423_(key) instanceof CompoundTag) {
            CompoundTag subTag = tag.m_128469_(key);
            return new CheckedNbtKey(key, subTag.m_128431_().stream().map(subKey -> ItemNbtCalculator.createKeyFromNbt(subKey, subTag)).collect(Collectors.toSet()));
        }
        return new CheckedNbtKey(key, Collections.emptySet());
    }

    public static CheckedNbtKey deserializeKeyFromJson(JsonObject jsonObject) {
        String key = jsonObject.get("key").getAsString();
        if (jsonObject.has("children")) {
            HashSet<CheckedNbtKey> children = new HashSet<CheckedNbtKey>();
            jsonObject.getAsJsonArray("children").forEach(child -> children.add(ItemNbtCalculator.deserializeKeyFromJson(child.getAsJsonObject())));
            return new CheckedNbtKey(key, children);
        }
        return new CheckedNbtKey(key, Collections.emptySet());
    }
}

