/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.ldtteam.domumornamentum.block.decorative.FloatingCarpetBlock;
import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.minecolonies.api.blocks.decorative.AbstractBlockMinecoloniesConstructionTape;
import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.IPathJob;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.PathingOptions;
import com.minecolonies.api.entity.pathfinding.SurfaceType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.PathingConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.blocks.BlockDecorationController;
import com.minecolonies.coremod.entity.pathfinding.CachingBlockLookup;
import com.minecolonies.coremod.entity.pathfinding.ChunkCache;
import com.minecolonies.coremod.entity.pathfinding.MNode;
import com.minecolonies.coremod.entity.pathfinding.PathPointExtended;
import com.minecolonies.coremod.network.messages.client.SyncPathMessage;
import com.minecolonies.coremod.network.messages.client.SyncPathReachedMessage;
import com.minecolonies.coremod.util.WorkerUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPathJob
implements Callable<Path>,
IPathJob {
    @NotNull
    protected final BlockPos start;
    protected BlockPos end = null;
    @NotNull
    protected final LevelReader world;
    protected CachingBlockLookup cachedBlockLookup;
    protected final PathResult result;
    protected final int maxRange;
    private final Queue<MNode> nodesOpen = new PriorityQueue<MNode>(500);
    private final Map<Integer, MNode> nodesVisited = new HashMap<Integer, MNode>();
    protected boolean debugDrawEnabled = false;
    @Nullable
    protected Set<MNode> debugNodesVisited = new HashSet<MNode>();
    @Nullable
    protected Set<MNode> debugNodesNotVisited = new HashSet<MNode>();
    @Nullable
    protected Set<MNode> debugNodesPath = new HashSet<MNode>();
    private final boolean allowJumpPointSearchTypeWalk;
    private int totalNodesAdded = 0;
    private int totalNodesVisited = 0;
    public static final Map<Player, UUID> trackingMap = new HashMap<Player, UUID>();
    private final AbstractAdvancedPathNavigate.RestrictionType restrictionType;
    private final boolean hardXzRestriction;
    private PathingOptions pathingOptions = new PathingOptions();
    private int maxX;
    private int minX;
    private int maxZ;
    private int minZ;
    private int maxY;
    private int minY;
    protected WeakReference<LivingEntity> entity;

    public AbstractPathJob(Level world, @NotNull BlockPos start, @NotNull BlockPos end, int range, LivingEntity entity) {
        this(world, start, end, range, new PathResult(), entity);
    }

    public AbstractPathJob(Level world, @NotNull BlockPos start, @NotNull BlockPos end, int range, PathResult result, LivingEntity entity) {
        int minX = Math.min(start.m_123341_(), end.m_123341_()) - range / 2;
        int minZ = Math.min(start.m_123343_(), end.m_123343_()) - range / 2;
        int maxX = Math.max(start.m_123341_(), end.m_123341_()) + range / 2;
        int maxZ = Math.max(start.m_123343_(), end.m_123343_()) + range / 2;
        this.restrictionType = AbstractAdvancedPathNavigate.RestrictionType.NONE;
        this.hardXzRestriction = false;
        this.world = new ChunkCache(world, new BlockPos(minX, world.m_141937_(), minZ), new BlockPos(maxX, world.m_151558_(), maxZ), range, world.m_6042_());
        this.start = new BlockPos((Vec3i)start);
        this.end = end;
        this.cachedBlockLookup = new CachingBlockLookup(start, this.world);
        this.maxRange = range;
        this.result = result;
        result.setJob(this);
        this.allowJumpPointSearchTypeWalk = false;
        if (entity != null && trackingMap.containsValue(entity.m_20148_())) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<MNode>();
            this.debugNodesNotVisited = new HashSet<MNode>();
            this.debugNodesPath = new HashSet<MNode>();
        }
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    public AbstractPathJob(Level world, BlockPos start, BlockPos startRestriction, BlockPos endRestriction, int range, boolean hardRestriction, PathResult result, LivingEntity entity, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        this(world, start, startRestriction, endRestriction, range, Vec3i.f_123288_, hardRestriction, result, entity, restrictionType);
    }

    public AbstractPathJob(Level world, @NotNull BlockPos start, BlockPos startRestriction, BlockPos endRestriction, int range, Vec3i grow, boolean hardRestriction, PathResult result, LivingEntity entity, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        this.minX = Math.min(startRestriction.m_123341_(), endRestriction.m_123341_()) - grow.m_123341_();
        this.minZ = Math.min(startRestriction.m_123343_(), endRestriction.m_123343_()) - grow.m_123343_();
        this.maxX = Math.max(startRestriction.m_123341_(), endRestriction.m_123341_()) + grow.m_123341_();
        this.maxZ = Math.max(startRestriction.m_123343_(), endRestriction.m_123343_()) + grow.m_123343_();
        this.minY = Math.min(startRestriction.m_123342_(), endRestriction.m_123342_()) - grow.m_123342_();
        this.maxY = Math.max(startRestriction.m_123342_(), endRestriction.m_123342_()) + grow.m_123342_();
        this.restrictionType = restrictionType;
        this.hardXzRestriction = hardRestriction;
        this.world = new ChunkCache(world, new BlockPos(this.minX, world.m_141937_(), this.minZ), new BlockPos(this.maxX, world.m_151558_(), this.maxZ), range, world.m_6042_());
        this.start = start;
        this.cachedBlockLookup = new CachingBlockLookup(start, this.world);
        this.maxRange = range;
        this.result = result;
        result.setJob(this);
        this.allowJumpPointSearchTypeWalk = false;
        if (entity != null && trackingMap.containsValue(entity.m_20148_())) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<MNode>();
            this.debugNodesNotVisited = new HashSet<MNode>();
            this.debugNodesPath = new HashSet<MNode>();
        }
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    public void synchToClient(LivingEntity mob) {
        Iterator<Map.Entry<Player, UUID>> iter = trackingMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Player, UUID> entry = iter.next();
            if (entry.getKey().m_213877_()) {
                iter.remove();
                continue;
            }
            if (!entry.getValue().equals(mob.m_20148_())) continue;
            Network.getNetwork().sendToPlayer(new SyncPathMessage(this.debugNodesVisited, this.debugNodesNotVisited, this.debugNodesPath), (ServerPlayer)entry.getKey());
        }
    }

    public static void synchToClient(HashSet<BlockPos> reached, Mob mob) {
        if (reached.isEmpty()) {
            return;
        }
        for (Map.Entry<Player, UUID> entry : trackingMap.entrySet()) {
            if (!entry.getValue().equals(mob.m_20148_())) continue;
            Network.getNetwork().sendToPlayer(new SyncPathReachedMessage(reached), (ServerPlayer)entry.getKey());
        }
    }

    protected boolean onLadderGoingUp(@NotNull MNode currentNode, @NotNull BlockPos dPos) {
        return currentNode.isLadder() && (dPos.m_123342_() >= 0 || dPos.m_123341_() != 0 || dPos.m_123343_() != 0);
    }

    public boolean isRestricted() {
        return this.restrictionType != AbstractAdvancedPathNavigate.RestrictionType.NONE;
    }

    public static BlockPos prepareStart(@NotNull LivingEntity entity) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(Mth.m_14107_((double)entity.m_20185_()), Mth.m_14107_((double)entity.m_20186_()), Mth.m_14107_((double)entity.m_20189_()));
        Level level = entity.f_19853_;
        BlockState bs = level.m_8055_((BlockPos)pos);
        VoxelShape collisionShape = bs.m_60812_((BlockGetter)level, (BlockPos)pos);
        boolean isFineToStandIn = AbstractPathJob.canStandInSolidBlock(bs);
        if (bs.m_60767_().m_76334_() && !isFineToStandIn && collisionShape.m_83297_(Direction.Axis.Y) > 0.0) {
            double relPosX = Math.abs(entity.m_20185_() % 1.0);
            double relPosZ = Math.abs(entity.m_20189_() % 1.0);
            for (AABB box : collisionShape.m_83299_()) {
                if (!(relPosX >= box.f_82288_) || !(relPosX <= box.f_82291_) || !(relPosZ >= box.f_82290_) || !(relPosZ <= box.f_82293_) || !(box.f_82292_ > 0.0)) continue;
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                bs = level.m_8055_((BlockPos)pos);
                break;
            }
        }
        BlockState down = level.m_8055_(pos.m_7495_());
        while (AbstractPathJob.canStandInSolidBlock(bs) && AbstractPathJob.canStandInSolidBlock(down) && !down.m_60734_().isLadder(down, (LevelReader)level, pos.m_7495_(), entity) && down.m_60819_().m_76178_()) {
            pos.m_122175_(Direction.DOWN, 1);
            bs = down;
            down = level.m_8055_(pos.m_7495_());
            if (pos.m_123342_() >= entity.m_20193_().m_141937_()) continue;
            return entity.m_20183_();
        }
        Block b = bs.m_60734_();
        if (entity.m_20069_()) {
            while (!bs.m_60819_().m_76178_()) {
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                bs = level.m_8055_((BlockPos)pos);
            }
        } else if (b instanceof FenceBlock || b instanceof WallBlock || b instanceof AbstractBlockMinecoloniesDefault || bs.m_60767_().m_76333_() && !AbstractPathJob.canStandInSolidBlock(bs)) {
            double dX = entity.m_20185_() - Math.floor(entity.m_20185_());
            double dZ = entity.m_20189_() - Math.floor(entity.m_20189_());
            if (dX < 0.5 && dZ < 0.5) {
                if (dZ < dX) {
                    pos.m_122178_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
                } else {
                    pos.m_122178_(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
                }
            } else if (dZ > dX) {
                pos.m_122178_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
            } else {
                pos.m_122178_(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
            }
        }
        return pos.m_7949_();
    }

    private static boolean canStandInSolidBlock(BlockState state) {
        return state.m_60734_() instanceof DoorBlock || state.m_60734_() instanceof TrapDoorBlock || state.m_60734_() instanceof PanelBlock && (Boolean)state.m_61143_((Property)PanelBlock.OPEN) != false || !state.m_60734_().f_60439_.f_60884_;
    }

    private static void setLadderFacing(@NotNull LevelReader world, BlockPos pos, @NotNull PathPointExtended p) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof VineBlock) {
            if (((Boolean)state.m_61143_((Property)VineBlock.f_57836_)).booleanValue()) {
                p.setLadderFacing(Direction.NORTH);
            } else if (((Boolean)state.m_61143_((Property)VineBlock.f_57837_)).booleanValue()) {
                p.setLadderFacing(Direction.EAST);
            } else if (((Boolean)state.m_61143_((Property)VineBlock.f_57834_)).booleanValue()) {
                p.setLadderFacing(Direction.SOUTH);
            } else if (((Boolean)state.m_61143_((Property)VineBlock.f_57835_)).booleanValue()) {
                p.setLadderFacing(Direction.WEST);
            }
        } else if (block instanceof LadderBlock) {
            p.setLadderFacing((Direction)state.m_61143_((Property)LadderBlock.f_54337_));
        } else {
            p.setLadderFacing(Direction.UP);
        }
    }

    private static boolean onALadder(@NotNull MNode node, @Nullable MNode nextInPath, @NotNull BlockPos pos) {
        return nextInPath != null && node.isLadder() && nextInPath.pos.m_123341_() == pos.m_123341_() && nextInPath.pos.m_123343_() == pos.m_123343_();
    }

    private static int computeNodeKey(@NotNull BlockPos pos) {
        return (pos.m_123341_() & 0xFFF) << 20 | (pos.m_123342_() & 0xFF) << 12 | pos.m_123343_() & 0xFFF;
    }

    protected double computeCost(@NotNull BlockPos dPos, boolean isSwimming, boolean onPath, boolean onRails, boolean railsExit, boolean swimStart, boolean corner, BlockState state, BlockPos blockPos) {
        double cost = Math.sqrt(dPos.m_123341_() * dPos.m_123341_() + dPos.m_123343_() * dPos.m_123343_());
        if (!(dPos.m_123342_() == 0 || Math.abs(dPos.m_123342_()) <= 1 && this.world.m_8055_(blockPos).m_60734_() instanceof StairBlock)) {
            if (dPos.m_123342_() > 0 && this.pathingOptions.jumpCost != 1.0) {
                cost *= this.pathingOptions.jumpCost * (double)Math.abs(dPos.m_123342_());
            } else if (this.pathingOptions.dropCost != 1.0) {
                cost *= this.pathingOptions.dropCost * (double)Math.abs(dPos.m_123342_());
            }
        }
        if (this.world.m_8055_(blockPos).m_61138_((Property)BlockStateProperties.f_61446_)) {
            cost *= this.pathingOptions.traverseToggleAbleCost;
        }
        if (onPath) {
            cost *= this.pathingOptions.onPathCost;
        }
        if (onRails) {
            cost *= this.pathingOptions.onRailCost;
        }
        if (railsExit) {
            cost *= this.pathingOptions.railsExitCost;
        }
        if (state.m_60734_() instanceof VineBlock) {
            cost *= this.pathingOptions.vineCost;
        }
        if (isSwimming) {
            cost = swimStart ? (cost *= this.pathingOptions.swimCostEnter) : (cost *= this.pathingOptions.swimCost);
        }
        return cost;
    }

    private static boolean nodeClosed(@Nullable MNode node) {
        return node != null && node.isClosed();
    }

    private static boolean calculateSwimming(@NotNull LevelReader world, @NotNull BlockPos pos, @Nullable MNode node) {
        return node == null ? SurfaceType.isWater((BlockGetter)world, pos.m_7495_()) : node.isSwimming();
    }

    @Override
    public PathResult getResult() {
        return this.result;
    }

    @Override
    public PathingOptions getPathingOptions() {
        return this.pathingOptions;
    }

    @Override
    public final Path call() {
        try {
            return this.search();
        }
        catch (Exception e) {
            Log.getLogger().warn("Pathfinding Exception", (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected Path search() {
        MNode bestNode = this.getAndSetupStartNode();
        double bestNodeResultScore = Double.MAX_VALUE;
        while (!this.nodesOpen.isEmpty()) {
            boolean isViablePosition;
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            MNode currentNode = this.nodesOpen.poll();
            ++this.totalNodesVisited;
            if (this.totalNodesVisited > this.maxRange * this.maxRange) break;
            currentNode.setCounterVisited(this.totalNodesVisited);
            this.handleDebugOptions(currentNode);
            currentNode.setClosed();
            boolean bl = isViablePosition = this.isInRestrictedArea(currentNode.pos) && SurfaceType.getSurfaceType((BlockGetter)this.world, this.world.m_8055_(currentNode.pos.m_7495_()), currentNode.pos.m_7495_()) == SurfaceType.WALKABLE;
            if (isViablePosition && this.isAtDestination(currentNode)) {
                bestNode = currentNode;
                this.result.setPathReachesDestination(true);
                break;
            }
            double nodeResultScore = this.getNodeResultScore(currentNode);
            if (isViablePosition && nodeResultScore < bestNodeResultScore && !currentNode.isCornerNode()) {
                bestNode = currentNode;
                bestNodeResultScore = nodeResultScore;
            }
            if (this.hardXzRestriction && !isViablePosition) continue;
            this.walkCurrentNode(currentNode);
        }
        @NotNull Path path = this.finalizePath(bestNode);
        return path;
    }

    private void handleDebugOptions(MNode currentNode) {
        if (this.debugDrawEnabled) {
            this.addNodeToDebug(currentNode);
        }
        if ((Integer)MineColonies.getConfig().getServer().pathfindingDebugVerbosity.get() == 2) {
            Log.getLogger().info(String.format("Examining node [%d,%d,%d] ; g=%f ; f=%f", currentNode.pos.m_123341_(), currentNode.pos.m_123342_(), currentNode.pos.m_123343_(), currentNode.getCost(), currentNode.getScore()));
        }
    }

    private void addNodeToDebug(MNode currentNode) {
        this.debugNodesNotVisited.remove(currentNode);
        this.debugNodesVisited.add(currentNode);
    }

    private void addPathNodeToDebug(MNode node) {
        this.debugNodesVisited.remove(node);
        this.debugNodesPath.add(node);
    }

    private void walkCurrentNode(@NotNull MNode currentNode) {
        this.cachedBlockLookup.resetToNextPos(currentNode.pos);
        BlockPos dPos = PathingConstants.BLOCKPOS_IDENTITY;
        if (currentNode.parent != null) {
            dPos = currentNode.pos.m_121996_((Vec3i)currentNode.parent.pos);
        }
        if (this.onLadderGoingUp(currentNode, dPos)) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_UP);
        }
        if (this.onLadderGoingDown(currentNode, dPos)) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
        }
        if ((currentNode.parent == null || !currentNode.parent.pos.equals((Object)currentNode.pos.m_7495_())) && currentNode.isCornerNode()) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
            return;
        }
        if (this.isPassable(currentNode.pos.m_7495_(), false, currentNode.parent) && !currentNode.isSwimming() && this.isLiquid(this.cachedBlockLookup.getBlockState(currentNode.pos.m_7495_()))) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
        }
        if (dPos.m_123343_() <= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_NORTH);
        }
        if (dPos.m_123341_() >= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_EAST);
        }
        if (dPos.m_123343_() >= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_SOUTH);
        }
        if (dPos.m_123341_() <= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_WEST);
        }
    }

    protected boolean onLadderGoingDown(@NotNull MNode currentNode, @NotNull BlockPos dPos) {
        return (dPos.m_123342_() <= 0 || dPos.m_123341_() != 0 || dPos.m_123343_() != 0) && this.isLadder(currentNode.pos.m_7495_());
    }

    @NotNull
    private MNode getAndSetupStartNode() {
        @NotNull MNode startNode = new MNode(this.start, this.computeHeuristic(this.start));
        if (this.isLadder(this.start)) {
            startNode.setLadder();
        } else if (this.isLiquid(this.world.m_8055_(this.start.m_7495_()))) {
            startNode.setSwimming();
        }
        startNode.setOnRails(this.pathingOptions.canUseRails() && this.world.m_8055_(this.start).m_60734_() instanceof BaseRailBlock);
        this.nodesOpen.offer(startNode);
        this.nodesVisited.put(AbstractPathJob.computeNodeKey(this.start), startNode);
        ++this.totalNodesAdded;
        return startNode;
    }

    public boolean isLiquid(BlockState state) {
        return state.m_60767_().m_76332_() || !state.m_60767_().m_76334_() && !state.m_60819_().m_76178_();
    }

    @NotNull
    private Path finalizePath(MNode targetNode) {
        int pathLength = 1;
        int railsLength = 0;
        MNode node = targetNode;
        while (node.parent != null) {
            ++pathLength;
            if (node.isOnRails()) {
                ++railsLength;
            }
            node = node.parent;
        }
        @NotNull Node[] points = new Node[pathLength];
        points[0] = new PathPointExtended(node.pos);
        if (this.debugDrawEnabled) {
            this.addPathNodeToDebug(node);
        }
        MNode nextInPath = null;
        PathPointExtended next = null;
        node = targetNode;
        while (node.parent != null) {
            if (this.debugDrawEnabled) {
                this.addPathNodeToDebug(node);
            }
            --pathLength;
            @NotNull BlockPos pos = node.pos;
            if (node.isSwimming()) {
                pos.m_121955_((Vec3i)PathingConstants.BLOCKPOS_DOWN);
            }
            @NotNull PathPointExtended p = new PathPointExtended(pos);
            if (railsLength >= (Integer)MineColonies.getConfig().getServer().minimumRailsToPath.get()) {
                PathPointExtended point;
                p.setOnRails(node.isOnRails());
                if (p.isOnRails() && (!node.parent.isOnRails() || node.parent.parent == null)) {
                    p.setRailsEntry();
                } else if (p.isOnRails() && points.length > pathLength + 1 && !(point = (PathPointExtended)points[pathLength + 1]).isOnRails()) {
                    point.setRailsExit();
                }
            }
            if (nextInPath != null && AbstractPathJob.onALadder(node, nextInPath, pos)) {
                p.setOnLadder(true);
                if (nextInPath.pos.m_123342_() > pos.m_123342_()) {
                    AbstractPathJob.setLadderFacing(this.world, pos, p);
                }
            } else if (AbstractPathJob.onALadder(node.parent, node.parent, pos)) {
                p.setOnLadder(true);
            }
            if (next != null) {
                next.f_77278_ = p;
            }
            next = p;
            points[pathLength] = p;
            nextInPath = node;
            node = node.parent;
        }
        this.doDebugPrinting(points);
        return new Path(Arrays.asList(points), this.getPathTargetPos(targetNode), this.isAtDestination(targetNode));
    }

    protected BlockPos getPathTargetPos(MNode finalNode) {
        return finalNode.pos;
    }

    private void doDebugPrinting(@NotNull Node[] points) {
        if ((Integer)MineColonies.getConfig().getServer().pathfindingDebugVerbosity.get() > 0) {
            Log.getLogger().info("Path found:");
            for (Node p : points) {
                Log.getLogger().info(String.format("Step: [%d,%d,%d]", p.f_77271_, p.f_77272_, p.f_77273_));
            }
            Log.getLogger().info(String.format("Total Nodes Visited %d / %d", this.totalNodesVisited, this.totalNodesAdded));
        }
    }

    protected abstract double computeHeuristic(BlockPos var1);

    protected abstract boolean isAtDestination(MNode var1);

    protected abstract double getNodeResultScore(MNode var1);

    protected final boolean walk(@NotNull MNode parent, @NotNull BlockPos dPos) {
        int nodeKey;
        MNode node;
        BlockPos pos = parent.pos.m_121955_((Vec3i)dPos);
        int newY = this.getGroundHeight(parent, pos);
        if (newY < this.world.m_141937_()) {
            return false;
        }
        boolean corner = false;
        if (pos.m_123342_() != newY) {
            if (parent.isCornerNode() && (dPos.m_123341_() != 0 || dPos.m_123343_() != 0)) {
                return false;
            }
            if (!(parent.isCornerNode() || newY - parent.pos.m_123342_() <= 0 || parent.parent != null && parent.parent.pos.equals((Object)parent.pos.m_121955_((Vec3i)new BlockPos(0, newY - pos.m_123342_(), 0))))) {
                dPos = new BlockPos(0, newY - pos.m_123342_(), 0);
                pos = parent.pos.m_121955_((Vec3i)dPos);
                corner = true;
            } else if (!(parent.isCornerNode() || newY - parent.pos.m_123342_() >= 0 || dPos.m_123341_() == 0 && dPos.m_123343_() == 0 || parent.parent != null && parent.pos.m_7495_().equals((Object)parent.parent.pos))) {
                dPos = new BlockPos(dPos.m_123341_(), 0, dPos.m_123343_());
                pos = parent.pos.m_121955_((Vec3i)dPos);
                corner = true;
            } else {
                dPos = dPos.m_7918_(0, newY - pos.m_123342_(), 0);
                pos = new BlockPos(pos.m_123341_(), newY, pos.m_123343_());
            }
        }
        if (AbstractPathJob.nodeClosed(node = this.nodesVisited.get(nodeKey = AbstractPathJob.computeNodeKey(pos)))) {
            return false;
        }
        boolean isSwimming = AbstractPathJob.calculateSwimming(this.world, pos, node);
        if (isSwimming && !this.pathingOptions.canSwim()) {
            return false;
        }
        boolean swimStart = isSwimming && !parent.isSwimming();
        BlockState state = this.cachedBlockLookup.getBlockState(pos);
        boolean onRoad = WorkerUtil.isPathBlock(this.cachedBlockLookup.getBlockState(pos.m_7495_()).m_60734_());
        boolean onRails = this.pathingOptions.canUseRails() && this.cachedBlockLookup.getBlockState(corner ? pos.m_7495_() : pos).m_60734_() instanceof BaseRailBlock;
        boolean railsExit = !onRails && parent != null && parent.isOnRails();
        double stepCost = this.computeCost(dPos, isSwimming, onRoad, onRails, railsExit, swimStart, corner, state, pos);
        stepCost = this.calcAdditionalCost(stepCost, parent, pos, state);
        double heuristic = this.computeHeuristic(pos);
        double cost = parent.getCost() + stepCost;
        double score = cost + heuristic;
        if (node == null) {
            node = this.createNode(parent, pos, nodeKey, isSwimming, heuristic, cost, score);
            node.setOnRails(onRails);
            node.setCornerNode(corner);
        } else if (this.updateCurrentNode(parent, node, heuristic, cost, score)) {
            return false;
        }
        this.nodesOpen.offer(node);
        this.performJumpPointSearch(parent, dPos, node);
        return true;
    }

    protected double calcAdditionalCost(double stepCost, MNode parent, BlockPos pos, BlockState state) {
        return stepCost;
    }

    private void performJumpPointSearch(@NotNull MNode parent, @NotNull BlockPos dPos, @NotNull MNode node) {
        if (this.allowJumpPointSearchTypeWalk && node.getHeuristic() <= parent.getHeuristic()) {
            this.walk(node, dPos);
        }
    }

    @NotNull
    private MNode createNode(MNode parent, @NotNull BlockPos pos, int nodeKey, boolean isSwimming, double heuristic, double cost, double score) {
        MNode node = new MNode(parent, pos, cost, heuristic, score);
        this.nodesVisited.put(nodeKey, node);
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.add(node);
        }
        if (this.isLadder(pos)) {
            node.setLadder();
        }
        if (isSwimming) {
            node.setSwimming();
        }
        ++this.totalNodesAdded;
        node.setCounterAdded(this.totalNodesAdded);
        return node;
    }

    private boolean updateCurrentNode(@NotNull MNode parent, @NotNull MNode node, double heuristic, double cost, double score) {
        if (score >= node.getScore()) {
            return true;
        }
        if (!this.nodesOpen.remove(node)) {
            return true;
        }
        node.parent = parent;
        node.setSteps(parent.getSteps() + 1);
        node.setCost(cost);
        node.setHeuristic(heuristic);
        node.setScore(score);
        return false;
    }

    protected int getGroundHeight(MNode parent, @NotNull BlockPos pos) {
        if (this.isLiquid(this.cachedBlockLookup.getBlockState(pos.m_7494_()))) {
            return -100;
        }
        if (this.checkHeadBlock(parent, pos)) {
            return this.handleTargetNotPassable(parent, pos.m_7494_(), this.cachedBlockLookup.getBlockState(pos.m_7494_()));
        }
        BlockState target = this.cachedBlockLookup.getBlockState(pos);
        if (!this.isPassable(target, pos, parent, false)) {
            return this.handleTargetNotPassable(parent, pos, target);
        }
        BlockState below = this.cachedBlockLookup.getBlockState(pos.m_7495_());
        SurfaceType walkability = SurfaceType.getSurfaceType((BlockGetter)this.world, below, pos);
        if (walkability == SurfaceType.WALKABLE) {
            return pos.m_123342_();
        }
        if (walkability == SurfaceType.NOT_PASSABLE) {
            return -100;
        }
        return this.handleNotStanding(parent, pos, below);
    }

    private int handleNotStanding(@Nullable MNode parent, @NotNull BlockPos pos, @NotNull BlockState below) {
        boolean isSwimming;
        boolean bl = isSwimming = parent != null && parent.isSwimming();
        if (this.isLiquid(below)) {
            return this.handleInLiquid(pos, below, isSwimming);
        }
        if (this.isLadder(below.m_60734_(), pos.m_7495_())) {
            return pos.m_123342_();
        }
        return this.checkDrop(parent, pos, isSwimming);
    }

    private int checkDrop(@Nullable MNode parent, @NotNull BlockPos pos, boolean isSwimming) {
        boolean canDrop;
        boolean bl = canDrop = parent != null && !parent.isLadder();
        if (!canDrop || (parent.pos.m_123341_() != pos.m_123341_() || parent.pos.m_123343_() != pos.m_123343_()) && this.isPassable(parent.pos.m_7495_(), false, parent) && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(parent.pos.m_7495_()), parent.pos.m_7495_()) == SurfaceType.DROPABLE) {
            return -100;
        }
        for (int i = 2; i <= 10; ++i) {
            BlockState below = this.cachedBlockLookup.getBlockState(pos.m_6625_(i));
            if (SurfaceType.getSurfaceType((BlockGetter)this.world, below, pos) == SurfaceType.WALKABLE && i <= 3 || this.isLiquid(below)) {
                return pos.m_123342_() - i + 1;
            }
            if (below.m_60767_() == Material.f_76296_) continue;
            return -100;
        }
        return -100;
    }

    private int handleInLiquid(@NotNull BlockPos pos, @NotNull BlockState below, boolean isSwimming) {
        if (isSwimming) {
            return pos.m_123342_();
        }
        if (this.pathingOptions.canSwim() && SurfaceType.isWater((BlockGetter)this.world, pos.m_7495_())) {
            return pos.m_123342_();
        }
        return -100;
    }

    private int handleTargetNotPassable(@Nullable MNode parent, @NotNull BlockPos pos, @NotNull BlockState target) {
        VoxelShape bb2;
        VoxelShape bb1;
        boolean canJump;
        boolean bl = canJump = parent != null && !parent.isLadder() && !parent.isSwimming();
        if (!canJump || SurfaceType.getSurfaceType((BlockGetter)this.world, target, pos) != SurfaceType.WALKABLE) {
            return -100;
        }
        if (!this.isPassable(pos.m_6630_(2), false, parent)) {
            bb1 = this.cachedBlockLookup.getBlockState(pos).m_60812_((BlockGetter)this.world, pos);
            bb2 = this.cachedBlockLookup.getBlockState(pos.m_6630_(2)).m_60812_((BlockGetter)this.world, pos.m_6630_(2));
            if ((double)pos.m_6630_(2).m_123342_() + this.getStartY(bb2, 1) - ((double)pos.m_123342_() + this.getEndY(bb1, 0)) < 2.0) {
                return -100;
            }
        }
        if (!this.canLeaveBlock(pos.m_6630_(2), parent, true)) {
            return -100;
        }
        if (!this.isPassable(parent.pos.m_6630_(2), false, parent)) {
            bb1 = this.cachedBlockLookup.getBlockState(pos).m_60812_((BlockGetter)this.world, pos);
            bb2 = this.cachedBlockLookup.getBlockState(parent.pos.m_6630_(2)).m_60812_((BlockGetter)this.world, parent.pos.m_6630_(2));
            if ((double)parent.pos.m_6630_(2).m_123342_() + this.getStartY(bb2, 1) - ((double)pos.m_123342_() + this.getEndY(bb1, 0)) < 2.0) {
                return -100;
            }
        }
        BlockState parentBelow = this.cachedBlockLookup.getBlockState(parent.pos.m_7495_());
        VoxelShape parentBB = parentBelow.m_60812_((BlockGetter)this.world, parent.pos.m_7495_());
        double parentY = parentBB.m_83297_(Direction.Axis.Y);
        double parentMaxY = parentY + (double)parent.pos.m_7495_().m_123342_();
        double targetMaxY = target.m_60812_((BlockGetter)this.world, pos).m_83297_(Direction.Axis.Y) + (double)pos.m_123342_();
        if (targetMaxY - parentMaxY < 1.3) {
            return pos.m_123342_() + 1;
        }
        if (target.m_60734_() instanceof StairBlock && parentY - 0.5 < 1.3 && target.m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM && BlockPosUtil.getXZFacing(parent.pos, pos) == target.m_61143_((Property)StairBlock.f_56841_)) {
            return pos.m_123342_() + 1;
        }
        return -100;
    }

    private boolean checkHeadBlock(@Nullable MNode parent, @NotNull BlockPos pos) {
        BlockPos localPos = pos;
        VoxelShape bb = this.cachedBlockLookup.getBlockState(localPos).m_60812_((BlockGetter)this.world, localPos);
        if (bb.m_83297_(Direction.Axis.Y) < 1.0) {
            localPos = pos.m_7494_();
        }
        if (!this.canLeaveBlock(pos.m_7494_(), parent, true)) {
            return true;
        }
        if (!this.isPassable(pos.m_7494_(), true, parent)) {
            VoxelShape bb1 = this.cachedBlockLookup.getBlockState(pos.m_7495_()).m_60812_((BlockGetter)this.world, pos.m_7495_());
            VoxelShape bb2 = this.cachedBlockLookup.getBlockState(pos.m_7494_()).m_60812_((BlockGetter)this.world, pos.m_7494_());
            if ((double)pos.m_7494_().m_123342_() + this.getStartY(bb2, 1) - ((double)pos.m_7495_().m_123342_() + this.getEndY(bb1, 0)) < 2.0) {
                return true;
            }
            if (parent != null) {
                VoxelShape bb3 = this.cachedBlockLookup.getBlockState(parent.pos.m_7495_()).m_60812_((BlockGetter)this.world, pos.m_7495_());
                if ((double)pos.m_7494_().m_123342_() + this.getStartY(bb2, 1) - ((double)parent.pos.m_7495_().m_123342_() + this.getEndY(bb3, 0)) < 1.75) {
                    return true;
                }
            }
        }
        if (parent != null) {
            BlockState hereState = this.cachedBlockLookup.getBlockState(localPos.m_7495_());
            VoxelShape bb1 = this.cachedBlockLookup.getBlockState(pos).m_60812_((BlockGetter)this.world, pos);
            VoxelShape bb2 = this.cachedBlockLookup.getBlockState(localPos.m_7494_()).m_60812_((BlockGetter)this.world, localPos.m_7494_());
            if ((double)localPos.m_7494_().m_123342_() + this.getStartY(bb2, 1) - ((double)pos.m_123342_() + this.getEndY(bb1, 0)) >= 2.0) {
                return false;
            }
            return this.isLiquid(hereState) && !this.isPassable(pos, false, parent);
        }
        return false;
    }

    private double getStartY(VoxelShape bb, int def) {
        return bb.m_83281_() ? (double)def : bb.m_83288_(Direction.Axis.Y);
    }

    private double getEndY(VoxelShape bb, int def) {
        return bb.m_83281_() ? (double)def : bb.m_83297_(Direction.Axis.Y);
    }

    protected boolean isPassable(@NotNull BlockState block, BlockPos pos, MNode parent, boolean head) {
        if (!this.canLeaveBlock(pos, parent, head)) {
            return false;
        }
        if (block.m_60767_() != Material.f_76296_) {
            BlockPathTypes pathType;
            VoxelShape shape = block.m_60812_((BlockGetter)this.world, pos);
            if (block.m_60767_().m_76334_() && !shape.m_83281_() && !(shape.m_83297_(Direction.Axis.Y) <= 0.1)) {
                if (block.m_60734_() instanceof TrapDoorBlock || block.m_60734_() instanceof PanelBlock) {
                    BlockPos parentPos;
                    BlockPos blockPos = parentPos = parent == null ? this.start : parent.pos;
                    if (head) {
                        parentPos = parentPos.m_7494_();
                    }
                    BlockPos dir = pos.m_121996_((Vec3i)parentPos);
                    Direction direction = BlockPosUtil.getXZFacing(parentPos, pos);
                    Direction facing = (Direction)block.m_61143_((Property)TrapDoorBlock.f_54117_);
                    if (block.m_60734_() instanceof PanelBlock && !((Boolean)block.m_61143_((Property)PanelBlock.OPEN)).booleanValue()) {
                        if (dir.m_123342_() == 0) {
                            return head && block.m_61143_((Property)PanelBlock.HALF) == Half.TOP;
                        }
                        if (head && dir.m_123342_() == 1 && block.m_61143_((Property)PanelBlock.HALF) == Half.TOP) {
                            return true;
                        }
                        return !head && dir.m_123342_() == -1 && block.m_61143_((Property)PanelBlock.HALF) == Half.BOTTOM;
                    }
                    if (direction == facing.m_122424_()) {
                        return true;
                    }
                    return direction != facing;
                }
                return this.pathingOptions.canEnterDoors() && (block.m_60734_() instanceof DoorBlock || block.m_60734_() instanceof FenceGateBlock) || block.m_60734_() instanceof AbstractBlockMinecoloniesConstructionTape || block.m_60734_() instanceof PressurePlateBlock || block.m_60734_() instanceof BlockDecorationController || block.m_60734_() instanceof SignBlock || block.m_60734_() instanceof AbstractBannerBlock || !block.m_60734_().f_60439_.f_60884_;
            }
            if (block.m_60734_() instanceof FireBlock || block.m_60734_() instanceof SweetBerryBushBlock || block.m_60734_() instanceof PowderSnowBlock) {
                return false;
            }
            if (this.isLadder(block.m_60734_(), pos)) {
                return true;
            }
            return !(!shape.m_83281_() && (!(shape.m_83297_(Direction.Axis.Y) <= 0.1) || this.isLiquid(block) || block.m_60734_() == Blocks.f_50125_ && (Integer)block.m_61143_((Property)SnowLayerBlock.f_56581_) != 1) || (pathType = block.getBlockPathType((BlockGetter)this.world, pos, (Mob)this.entity.get())) != null && pathType.getDanger() != null);
        }
        return true;
    }

    protected boolean isPassable(BlockPos pos, boolean head, MNode parent) {
        BlockState state = this.cachedBlockLookup.getBlockState(pos);
        VoxelShape shape = state.m_60812_((BlockGetter)this.world, pos);
        if (shape.m_83281_() || shape.m_83297_(Direction.Axis.Y) <= 0.1) {
            return !head || !(state.m_60734_() instanceof WoolCarpetBlock) && !(state.m_60734_() instanceof FloatingCarpetBlock) || this.isLadder(state.m_60734_(), pos);
        }
        return this.isPassable(state, pos, parent, head);
    }

    private boolean canLeaveBlock(BlockPos pos, MNode parent, boolean head) {
        BlockState parentBlock;
        BlockPos parentPos;
        BlockPos blockPos = parentPos = parent == null ? this.start : parent.pos;
        if (head) {
            parentPos = parentPos.m_7494_();
        }
        if ((parentBlock = this.cachedBlockLookup.getBlockState(parentPos)).m_60734_() instanceof TrapDoorBlock || parentBlock.m_60734_() instanceof PanelBlock) {
            Direction facing;
            Direction direction;
            BlockPos dir = pos.m_121996_((Vec3i)parentPos);
            if (!((Boolean)parentBlock.m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue()) {
                if (dir.m_123342_() != 0) {
                    return head && parentBlock.m_61143_((Property)PanelBlock.HALF) == Half.TOP && dir.m_123342_() < 0 || !head && parentBlock.m_61143_((Property)PanelBlock.HALF) == Half.BOTTOM && dir.m_123342_() > 0;
                }
                return true;
            }
            if ((dir.m_123341_() != 0 || dir.m_123343_() != 0) && (direction = BlockPosUtil.getXZFacing(parentPos, pos)) == (facing = (Direction)parentBlock.m_61143_((Property)TrapDoorBlock.f_54117_)).m_122424_()) {
                return false;
            }
        }
        return true;
    }

    protected boolean isLadder(@NotNull Block block, BlockPos pos) {
        return block.isLadder(this.cachedBlockLookup.getBlockState(pos), this.world, pos, (LivingEntity)this.entity.get()) && (block != Blocks.f_50191_ || this.pathingOptions.canClimbVines());
    }

    protected boolean isLadder(BlockPos pos) {
        return this.isLadder(this.cachedBlockLookup.getBlockState(pos).m_60734_(), pos);
    }

    public void setPathingOptions(PathingOptions pathingOptions) {
        this.pathingOptions.importFrom(pathingOptions);
    }

    public boolean isInRestrictedArea(BlockPos pos) {
        boolean isInXZ;
        if (this.restrictionType == AbstractAdvancedPathNavigate.RestrictionType.NONE) {
            return true;
        }
        boolean bl = isInXZ = pos.m_123341_() <= this.maxX && pos.m_123343_() <= this.maxZ && pos.m_123343_() >= this.minZ && pos.m_123341_() >= this.minX;
        if (!isInXZ) {
            return false;
        }
        if (this.restrictionType == AbstractAdvancedPathNavigate.RestrictionType.XZ) {
            return true;
        }
        return pos.m_123342_() <= this.maxY && pos.m_123342_() >= this.minY;
    }
}

