/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.states.CitizenAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.tileentities.TileEntityNamedGrave;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.modules.GraveyardManagementModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingGraveyard;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.StringUtils;

public class EntityAIMournCitizen
implements IStateAI {
    private final EntityCitizen citizen;
    private final double speed;
    private Entity closestEntity;
    private static final int MIN_DESTINATION_TO_LOCATION = 225;
    private static final int AVERAGE_MOURN_TIME = 300;
    private static final int AVERAGE_STARE_TIME = 200;
    private BlockPos graveyard;
    private BlockPos gravePos;

    public EntityAIMournCitizen(EntityCitizen citizen, double speed) {
        this.citizen = citizen;
        this.speed = speed;
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(CitizenAIState.MOURN, () -> {
            this.reset();
            return true;
        }, () -> MourningState.DECIDE, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.DECIDE, () -> true, this::decide, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.WALKING_TO_TOWNHALL, () -> true, this::walkToTownHall, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.WANDERING, () -> true, this::wander, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.STARING, () -> true, this::stare, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.WALKING_TO_GRAVEYARD, () -> true, this::walkToGraveyard, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.WANDER_AT_GRAVEYARD, () -> true, this::wanderAtGraveyard, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(MourningState.WALK_TO_GRAVE, () -> true, this::walkToGrave, 20));
    }

    private IState walkToTownHall() {
        BlockPos pos = this.getMournLocation();
        this.citizen.getNavigation().moveToXYZ(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.speed);
        return CitizenAIState.IDLE;
    }

    private IState walkToGraveyard() {
        if (this.graveyard == null) {
            return MourningState.DECIDE;
        }
        if (!this.citizen.isWorkerAtSiteWithMove(this.graveyard, 3)) {
            return MourningState.WALKING_TO_GRAVEYARD;
        }
        return MourningState.WANDER_AT_GRAVEYARD;
    }

    private IState wanderAtGraveyard() {
        if (this.graveyard == null) {
            return MourningState.DECIDE;
        }
        IBuilding graveyardBuilding = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(this.graveyard);
        if (!(graveyardBuilding instanceof BuildingGraveyard)) {
            this.graveyard = null;
            return MourningState.DECIDE;
        }
        if (!this.citizen.getNavigation().m_26571_()) {
            return MourningState.WANDER_AT_GRAVEYARD;
        }
        if (MathUtils.RANDOM.nextInt(100) < 90) {
            this.citizen.getNavigation().moveToRandomPos(10, 0.6, graveyardBuilding.getCorners(), AbstractAdvancedPathNavigate.RestrictionType.XYZ, false);
            return MourningState.WANDER_AT_GRAVEYARD;
        }
        Set<Tuple<BlockPos, Direction>> gravePositions = ((BuildingGraveyard)graveyardBuilding).getGravePositions();
        for (Tuple<BlockPos, Direction> gravePos : gravePositions) {
            Iterator<String> iterator;
            BlockEntity blockEntity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.citizen.f_19853_, gravePos.getA()) || !((blockEntity = this.citizen.f_19853_.m_7702_(gravePos.getA())) instanceof TileEntityNamedGrave) || !(iterator = this.citizen.getCitizenData().getCitizenMournHandler().getDeceasedCitizens().iterator()).hasNext()) continue;
            String deathBud = iterator.next();
            String firstName = StringUtils.split((String)deathBud)[0];
            String lastName = deathBud.replaceFirst(firstName, "");
            ArrayList<String> graveNameList = ((TileEntityNamedGrave)blockEntity).getTextLines();
            if (graveNameList.isEmpty() || !graveNameList.contains(firstName) || !graveNameList.contains(lastName)) continue;
            this.gravePos = gravePos.getA();
            return MourningState.WALK_TO_GRAVE;
        }
        return MourningState.DECIDE;
    }

    private IState walkToGrave() {
        if (this.gravePos == null) {
            return MourningState.DECIDE;
        }
        if (!this.citizen.isWorkerAtSiteWithMove(this.gravePos, 3)) {
            return MourningState.WALK_TO_GRAVE;
        }
        return MourningState.DECIDE;
    }

    private IState wander() {
        this.citizen.getNavigation().moveToRandomPos(10.0, this.speed);
        return CitizenAIState.IDLE;
    }

    private IState stare() {
        if (this.citizen.m_217043_().m_188503_(200) < 1) {
            this.closestEntity = null;
            return CitizenAIState.IDLE;
        }
        if (this.closestEntity == null) {
            this.closestEntity = this.citizen.f_19853_.m_45963_(EntityCitizen.class, TargetingConditions.f_26872_, (LivingEntity)this.citizen, this.citizen.m_20185_(), this.citizen.m_20186_(), this.citizen.m_20189_(), this.citizen.m_20191_().m_82377_(3.0, 3.0, 3.0));
            if (this.closestEntity == null) {
                return CitizenAIState.IDLE;
            }
        }
        this.citizen.m_21563_().m_24950_(this.closestEntity.m_20185_(), this.closestEntity.m_20186_() + (double)this.closestEntity.m_20192_(), this.closestEntity.m_20189_(), (float)this.citizen.m_8085_(), (float)this.citizen.m_8132_());
        return MourningState.STARING;
    }

    private IState decide() {
        if (!this.citizen.getNavigation().m_26571_()) {
            return CitizenAIState.IDLE;
        }
        if (this.citizen.m_217043_().m_188499_()) {
            return MourningState.STARING;
        }
        if (this.graveyard == null) {
            this.graveyard = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getFirstBuildingMatching(b -> b instanceof BuildingGraveyard && ((GraveyardManagementModule)b.getFirstModuleOccurance(GraveyardManagementModule.class)).hasRestingCitizen(this.citizen.getCitizenData().getCitizenMournHandler().getDeceasedCitizens()));
        }
        if (this.graveyard != null) {
            return MourningState.WALKING_TO_GRAVEYARD;
        }
        this.citizen.m_21563_().m_24950_(this.citizen.m_20185_(), this.citizen.m_20186_() - 10.0, this.citizen.m_20189_(), (float)this.citizen.m_8085_(), (float)this.citizen.m_8132_());
        if (BlockPosUtil.getDistance2D(this.citizen.m_20183_(), this.getMournLocation()) > 225L) {
            return MourningState.WALKING_TO_TOWNHALL;
        }
        return MourningState.WANDERING;
    }

    public void reset() {
        this.citizen.getCitizenData().setVisibleStatus(null);
        this.graveyard = null;
        this.gravePos = null;
    }

    protected BlockPos getMournLocation() {
        IColony colony = this.citizen.getCitizenColonyHandler().getColony();
        if (colony == null || !colony.getBuildingManager().hasTownHall()) {
            return this.citizen.m_21534_();
        }
        return colony.getBuildingManager().getTownHall().getPosition();
    }

    public static enum MourningState implements IState
    {
        DECIDE,
        WALKING_TO_TOWNHALL,
        WANDERING,
        STARING,
        WALKING_TO_GRAVEYARD,
        WANDER_AT_GRAVEYARD,
        WALK_TO_GRAVE;

    }
}

