/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.sifter;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSifter;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobSifter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.network.messages.client.LocalizedParticleEffectMessage;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkSifter
extends AbstractEntityAICrafting<JobSifter, BuildingSifter> {
    private static final int MAX_LEVEL = 50;
    private static final int TICK_DELAY = 10;
    private static final int CHANCE_TO_DUMP_INV = 10;
    private static final int NO_MESH_DELAY = 100;
    protected int progress = 0;

    public EntityAIWorkSifter(@NotNull JobSifter job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 10), new AITarget<AIWorkerState>(AIWorkerState.START_WORKING, AIWorkerState.SIFT, 1), new AITarget<Object>(AIWorkerState.SIFT, this::sift, 10));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingSifter> getExpectedBuildingClass() {
        return BuildingSifter.class;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    protected IAIState sift() {
        BuildingSifter sifterBuilding = (BuildingSifter)this.building;
        if (sifterBuilding.getCurrentDailyQuantity() >= sifterBuilding.getMaxDailyQuantity()) {
            return AIWorkerState.IDLE;
        }
        if (this.walkToBuilding()) {
            return this.getState();
        }
        if (InventoryUtils.isItemHandlerFull((IItemHandler)this.worker.getInventoryCitizen())) {
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRecipeStorage == null) {
            ICraftingBuildingModule module = (ICraftingBuildingModule)((BuildingSifter)this.building).getFirstModuleOccurance(BuildingSifter.CraftingModule.class);
            this.currentRecipeStorage = module.getFirstFulfillableRecipe(ItemStackUtils::isEmpty, 1, false);
        }
        if (this.currentRecipeStorage == null) {
            if (InventoryUtils.hasBuildingEnoughElseCount((IBuilding)sifterBuilding, i -> i.m_204117_(ModTags.meshes), 1) == 0) {
                if (InventoryUtils.getItemCountInProvider((ICapabilityProvider)this.worker, i -> i.m_204117_(ModTags.meshes)) > 0) {
                    this.incrementActionsDone();
                    return AIWorkerState.INVENTORY_FULL;
                }
                if (this.worker.getCitizenData() != null) {
                    this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.sifter.nomesh"), ChatPriority.IMPORTANT));
                    this.setDelay(100);
                }
            }
            if (!ItemStackUtils.isEmpty(this.worker.m_21205_())) {
                this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            if (!ItemStackUtils.isEmpty(this.worker.m_21206_())) {
                this.worker.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            }
            this.progress = 0;
            return AIWorkerState.START_WORKING;
        }
        ItemStack meshItem = this.currentRecipeStorage.getCraftingTools().get(0);
        ItemStack inputItem = this.currentRecipeStorage.getCleanedInput().stream().map(ItemStorage::getItemStack).filter(item -> !ItemStackUtils.compareItemStacksIgnoreStackSize(item, meshItem, false, true)).findFirst().orElse(ItemStack.f_41583_);
        if (meshItem.m_41619_() || inputItem.m_41619_()) {
            this.currentRecipeStorage = null;
            return this.getState();
        }
        if (!inputItem.m_41619_() && (ItemStackUtils.isEmpty(this.worker.m_21205_()) || ItemStackUtils.compareItemStacksIgnoreStackSize(this.worker.m_21205_(), inputItem).booleanValue())) {
            this.worker.m_21008_(InteractionHand.MAIN_HAND, inputItem);
        }
        if (!meshItem.m_41619_() && (ItemStackUtils.isEmpty(this.worker.m_21206_()) || ItemStackUtils.compareItemStacksIgnoreStackSize(this.worker.m_21206_(), meshItem, false, true))) {
            this.worker.m_21008_(InteractionHand.OFF_HAND, meshItem);
        }
        WorkerUtil.faceBlock(((BuildingSifter)this.building).getPosition(), this.worker);
        ++this.progress;
        if (this.progress > 50 - this.getEffectiveSkillLevel(this.getSecondarySkillLevel()) / 2) {
            this.progress = 0;
            sifterBuilding.setCurrentDailyQuantity(sifterBuilding.getCurrentDailyQuantity() + 1);
            if (sifterBuilding.getCurrentDailyQuantity() >= sifterBuilding.getMaxDailyQuantity() || this.worker.m_217043_().m_188503_(100) < 10) {
                this.incrementActionsDoneAndDecSaturation();
            }
            if (!this.currentRecipeStorage.fullfillRecipe(this.getLootContext(), sifterBuilding.getHandlers())) {
                this.currentRecipeStorage = null;
                return this.getState();
            }
            this.worker.decreaseSaturationForContinuousAction();
            this.worker.getCitizenExperienceHandler().addExperience(0.2);
        }
        Network.getNetwork().sendToTrackingEntity(new LocalizedParticleEffectMessage(meshItem, sifterBuilding.getID()), (Entity)this.worker);
        Network.getNetwork().sendToTrackingEntity(new LocalizedParticleEffectMessage(inputItem, sifterBuilding.getID().m_7495_()), (Entity)this.worker);
        this.worker.m_6674_(InteractionHand.MAIN_HAND);
        SoundUtils.playSoundAtCitizen(this.world, ((BuildingSifter)this.building).getID(), SoundEvents.f_12033_);
        return this.getState();
    }
}

