/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.coremod.entity.ai.citizen.miner.MinerLevel;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Node {
    private static final String TAG_X = "idX";
    private static final String TAG_Z = "idZ";
    private static final String TAG_ROT = "rotation";
    private static final String TAG_STYLE = "Style";
    private static final String TAG_STATUS = "Status";
    private static final String TAG_PARENTX = "ParentX";
    private static final String TAG_PARENTZ = "ParentZ";
    private final Random random = new Random();
    private static final int DISTANCE_TO_NEXT_NODE = 7;
    private final int x;
    private final int z;
    private Optional<Integer> rot = Optional.empty();
    @Nullable
    private final Vec2i parent;
    @NotNull
    private NodeType style;
    @NotNull
    private NodeStatus status;

    public Node(int x, int z, @Nullable Vec2i parent) {
        this.x = x;
        this.z = z;
        this.style = NodeType.UNDEFINED;
        this.status = NodeStatus.AVAILABLE;
        this.parent = parent;
    }

    @NotNull
    public static Node createFromNBT(@NotNull CompoundTag compound) {
        NodeType style;
        int z;
        int x;
        boolean hasDoubles = compound.m_128441_(TAG_X);
        if (hasDoubles) {
            x = Mth.m_14107_((double)compound.m_128459_(TAG_X));
            z = Mth.m_14107_((double)compound.m_128459_(TAG_Z));
        } else {
            x = compound.m_128451_(TAG_X);
            z = compound.m_128451_(TAG_Z);
        }
        try {
            style = NodeType.valueOf(compound.m_128461_(TAG_STYLE));
        }
        catch (IllegalArgumentException ex) {
            style = NodeType.BEND_RIGHT;
        }
        NodeStatus status = NodeStatus.valueOf(compound.m_128461_(TAG_STATUS));
        Vec2i parent = null;
        if (compound.m_128441_(TAG_PARENTX)) {
            parent = hasDoubles ? new Vec2i(Mth.m_14107_((double)compound.m_128459_(TAG_PARENTX)), Mth.m_14107_((double)compound.m_128459_(TAG_PARENTZ))) : new Vec2i(compound.m_128451_(TAG_PARENTX), compound.m_128451_(TAG_PARENTZ));
        }
        @NotNull Node node = new Node(x, z, parent);
        if (style == NodeType.UNDEFINED) {
            Log.getLogger().error("Minecolonies Node " + x + "," + z + " has an undefined style, please tell the mod author about this");
        }
        node.setStyle(style);
        node.setStatus(status);
        if (compound.m_128441_(TAG_ROT)) {
            node.setRot(compound.m_128451_(TAG_ROT));
        }
        return node;
    }

    public void write(@NotNull CompoundTag compound) {
        compound.m_128405_(TAG_X, this.x);
        compound.m_128405_(TAG_Z, this.z);
        if (this.rot.isPresent()) {
            compound.m_128405_(TAG_ROT, this.rot.get().intValue());
        }
        compound.m_128359_(TAG_STYLE, this.style.name());
        compound.m_128359_(TAG_STATUS, this.status.name());
        if (this.parent != null) {
            compound.m_128405_(TAG_PARENTX, this.parent.getX());
            compound.m_128405_(TAG_PARENTZ, this.parent.getZ());
        }
    }

    @NotNull
    public NodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull NodeStatus status) {
        this.status = status;
    }

    @Nullable
    public Vec2i getParent() {
        return this.parent;
    }

    @NotNull
    public String toString() {
        return "Node{x=" + this.x + ", z=" + this.z + ", style=" + this.style + ", status=" + this.status + "}";
    }

    @NotNull
    public NodeType getStyle() {
        return this.style;
    }

    public void setStyle(@NotNull NodeType style) {
        this.style = style;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public Vec2i getNorthNodeCenter() {
        return new Vec2i(this.getX(), this.getZ() - 7);
    }

    public Vec2i getSouthNodeCenter() {
        return new Vec2i(this.getX(), this.getZ() + 7);
    }

    public Vec2i getEastNodeCenter() {
        return new Vec2i(this.getX() + 7, this.getZ());
    }

    public Vec2i getWestNodeCenter() {
        return new Vec2i(this.getX() - 7, this.getZ());
    }

    @Nullable
    public Node getRandomNextNode(MinerLevel level, int step) {
        if (step > 3) {
            return null;
        }
        Node nextNode = switch (this.random.nextInt(3)) {
            case 0 -> level.getOpenNode(this.getNorthNodeCenter());
            case 1 -> level.getOpenNode(this.getSouthNodeCenter());
            case 2 -> level.getOpenNode(this.getEastNodeCenter());
            default -> level.getOpenNode(this.getWestNodeCenter());
        };
        if (nextNode == null || nextNode.style == NodeType.SHAFT) {
            Node parent = level.getOpenNode(this.getParent());
            return parent == null ? null : parent.getRandomNextNode(level, step + 1);
        }
        return nextNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.x == node.x && this.z == node.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public Optional<Integer> getRot() {
        return this.rot;
    }

    public void setRot(int rot) {
        this.rot = Optional.of(rot);
    }

    public static enum NodeType {
        SHAFT("infrastructure/mineshafts/minermainshaft"),
        LADDER_BACK(""),
        TUNNEL("infrastructure/mineshafts/minerx2top"),
        CROSSROAD("infrastructure/mineshafts/minerx4"),
        BEND_RIGHT("infrastructure/mineshafts/minerx2right"),
        UNDEFINED(""),
        BEND_LEFT("infrastructure/mineshafts/minerx2left"),
        CROSS_THREE_LEFT_RIGHT("infrastructure/mineshafts/minerx3leftright"),
        CROSS_THREE_TOP_LEFT("infrastructure/mineshafts/minerx3topleft"),
        CROSS_THREE_TOP_RIGHT("infrastructure/mineshafts/minerx3topright");

        public static final ImmutableList<NodeType> SIDE_NODES;
        private String schemName;

        private NodeType(String schemName) {
            this.schemName = schemName;
        }

        public String getSchematicName() {
            return this.schemName;
        }

        static {
            SIDE_NODES = ImmutableList.of((Object)((Object)TUNNEL), (Object)((Object)CROSSROAD), (Object)((Object)BEND_RIGHT), (Object)((Object)BEND_LEFT), (Object)((Object)CROSS_THREE_LEFT_RIGHT), (Object)((Object)CROSS_THREE_TOP_LEFT), (Object)((Object)CROSS_THREE_TOP_RIGHT));
        }
    }

    public static enum NodeStatus {
        AVAILABLE,
        IN_PROGRESS,
        COMPLETED;

    }
}

