/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.Level;

public class CommandColonyChunks
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        HashSet<TicketType> types = new HashSet<TicketType>();
        for (Long chunkLong : colony.getLoadedChunks()) {
            SortedArraySet tickets = (SortedArraySet)((CommandSourceStack)context.getSource()).m_81372_().m_7726_().f_8325_.m_143145_().f_140761_.get(chunkLong.longValue());
            if (tickets == null) continue;
            for (Ticket ticket : tickets) {
                types.add(ticket.m_9428_());
            }
        }
        StringBuilder ticketString = new StringBuilder();
        for (TicketType type : types) {
            ticketString.append("[").append(type).append("]");
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"ID: ").m_7220_((Component)Component.m_237113_((String)("" + colony.getID())).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" Name: ")).m_7220_((Component)Component.m_237113_((String)colony.getName()).m_130940_(ChatFormatting.YELLOW)), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"Loaded chunks:").m_7220_((Component)Component.m_237113_((String)(" " + colony.getLoadedChunkCount())).m_130940_(ChatFormatting.YELLOW)), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"Ticket types: ").m_7220_((Component)Component.m_237113_((String)ticketString.toString()).m_130940_(ChatFormatting.YELLOW)), true);
        return 1;
    }

    @Override
    public String getName() {
        return "chunkstatus";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute));
    }
}

