/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingRequestResolver;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class PublicWorkerCraftingRequestResolverFactory
implements IRequestResolverFactory<PublicWorkerCraftingRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";
    private static final String NBT_JOB = "Job";

    @Override
    @NotNull
    public TypeToken<? extends PublicWorkerCraftingRequestResolver> getFactoryOutputType() {
        return TypeToken.of(PublicWorkerCraftingRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public PublicWorkerCraftingRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) {
        return new PublicWorkerCraftingRequestResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN), (JobEntry)context[0]);
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull PublicWorkerCraftingRequestResolver publicWorkerCraftingRequestResolverFactory) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_(NBT_TOKEN, (Tag)controller.serialize(publicWorkerCraftingRequestResolverFactory.getId()));
        compound.m_128365_(NBT_LOCATION, (Tag)controller.serialize(publicWorkerCraftingRequestResolverFactory.getLocation()));
        compound.m_128359_(NBT_JOB, IJobRegistry.getInstance().getKey((Object)publicWorkerCraftingRequestResolverFactory.getJobEntry()).toString());
        return compound;
    }

    @Override
    @NotNull
    public PublicWorkerCraftingRequestResolver deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        IToken token = (IToken)controller.deserialize(nbt.m_128469_(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.m_128469_(NBT_LOCATION));
        JobEntry entry = (JobEntry)IJobRegistry.getInstance().getValue(new ResourceLocation(nbt.m_128461_(NBT_JOB)));
        return new PublicWorkerCraftingRequestResolver(location, token, entry);
    }

    @Override
    public void serialize(IFactoryController controller, PublicWorkerCraftingRequestResolver input, FriendlyByteBuf packetBuffer) {
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
        packetBuffer.writeRegistryId(IMinecoloniesAPI.getInstance().getJobRegistry(), (Object)input.getJobEntry());
    }

    @Override
    public PublicWorkerCraftingRequestResolver deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        JobEntry entry = (JobEntry)buffer.readRegistryId();
        return new PublicWorkerCraftingRequestResolver(location, token, entry);
    }

    @Override
    public short getSerializationId() {
        return 20;
    }
}

