/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.interactionhandling;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.quests.IDialogueObjectiveTemplate;
import com.minecolonies.api.quests.IFinalQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestDeliveryObjective;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.api.quests.IQuestPositiveDialogueAnswer;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.interactionhandling.QuestDialogueInteraction;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIBasic;
import com.minecolonies.coremod.network.messages.server.colony.InteractionResponse;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class QuestDeliveryInteraction
extends QuestDialogueInteraction {
    private static final ResourceLocation QUEST_START_ICON = new ResourceLocation("minecolonies", "textures/icons/queststart.png");
    private static final ResourceLocation QUEST_NEXT_TASK_ICON = new ResourceLocation("minecolonies", "textures/icons/nexttask.png");

    public QuestDeliveryInteraction(Component inquiry, IChatPriority priority, ResourceLocation location, int index, ICitizenData citizenData) {
        super(inquiry, priority, location, index, citizenData);
    }

    public QuestDeliveryInteraction(ICitizen data) {
        super(data);
    }

    @Override
    public void onServerResponseTriggered(int responseId, Player player, ICitizenData data) {
        if (this.colonyQuest == null) {
            this.colonyQuest = data.getColony().getQuestManager().getAvailableOrInProgressQuest(this.questId);
        }
        IQuestObjectiveTemplate objective = IQuestManager.GLOBAL_SERVER_QUESTS.get(this.questId).getObjective(this.index);
        this.triggerResponseState(player, objective);
        if (this.currentElement != null && this.colonyQuest != null) {
            IQuestDialogueAnswer result = this.currentElement.getOptionResult(responseId);
            if (result instanceof IFinalQuestDialogueAnswer) {
                if (result instanceof IQuestPositiveDialogueAnswer) {
                    if (((IQuestDeliveryObjective)objective).hasItem(player, this.colonyQuest) && ((IQuestDeliveryObjective)objective).tryDiscountItem(player, this.colonyQuest)) {
                        ((IFinalQuestDialogueAnswer)result).applyToQuest(player, this.colonyQuest);
                        this.finished = true;
                    }
                } else if (!(result instanceof IQuestDialogueAnswer.CloseUIDialogueAnswer)) {
                    this.currentElement = null;
                    data.getColony().markDirty();
                    return;
                }
                this.currentElement = this.startElement;
            } else if (result instanceof IDialogueObjectiveTemplate.DialogueElement) {
                this.currentElement = (IDialogueObjectiveTemplate.DialogueElement)result;
                if (data != null && data.getJob() != null) {
                    ((AbstractEntityAIBasic)data.getJob().getWorkerAI()).setDelay(60);
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(int responseId, Player player, ICitizenDataView data, BOWindow window) {
        if (this.colonyQuest == null) {
            this.colonyQuest = data.getColony().getQuestManager().getAvailableOrInProgressQuest(this.questId);
        }
        if (this.currentElement != null && this.colonyQuest != null) {
            IQuestDialogueAnswer result = this.currentElement.getOptionResult(responseId);
            if (result instanceof IFinalQuestDialogueAnswer) {
                Network.getNetwork().sendToServer(new InteractionResponse(data.getColonyId(), data.getId(), (ResourceKey<Level>)player.f_19853_.m_46472_(), (Component)Component.m_237113_((String)this.colonyQuest.getId().toString()), responseId));
                this.currentElement = this.startElement;
                return true;
            }
            if (result instanceof IDialogueObjectiveTemplate.DialogueElement) {
                Network.getNetwork().sendToServer(new InteractionResponse(data.getColonyId(), data.getId(), (ResourceKey<Level>)player.f_19853_.m_46472_(), (Component)Component.m_237113_((String)this.colonyQuest.getId().toString()), responseId));
                this.currentElement = (IDialogueObjectiveTemplate.DialogueElement)result;
                return false;
            }
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onOpened(Player player) {
        IQuestObjectiveTemplate objective = IQuestManager.GLOBAL_SERVER_QUESTS.get(this.questId).getObjective(this.index);
        this.triggerResponseState(player, objective);
    }

    private void triggerResponseState(Player player, IQuestObjectiveTemplate objective) {
        if (objective instanceof IQuestDeliveryObjective) {
            IQuestDeliveryObjective delivery = (IQuestDeliveryObjective)objective;
            this.currentElement = delivery.hasItem(player, this.colonyQuest) ? delivery.getReadyDialogueTree() : delivery.getDialogueTree();
        }
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.QUEST_ACTION.m_135815_();
    }

    @Override
    public ResourceLocation getInteractionIcon() {
        return this.index == 0 ? QUEST_START_ICON : QUEST_NEXT_TASK_ICON;
    }
}

