/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.IItemStorageFactory;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.TypeConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStorageFactory
implements IItemStorageFactory {
    private static final String TAG_SIZE = "size";
    private static final String TAG_STACK = "stack";
    private static final String TAG_SHOULDIGNORENBT = "ignoreNBT";
    private static final String TAG_SHOULDIGNOREDAMAGE = "ignoreDamage";

    @Override
    @NotNull
    public TypeToken<ItemStorage> getFactoryOutputType() {
        return TypeConstants.ITEMSTORAGE;
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public ItemStorage getNewInstance(@NotNull ItemStack stack, int size, boolean ignoreDamage, boolean ignoreNBT) {
        ItemStorage newItem = new ItemStorage(stack, ignoreDamage, ignoreNBT);
        newItem.setAmount(size);
        return newItem;
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull ItemStorage storage) {
        CompoundTag compound = new CompoundTag();
        @NotNull CompoundTag stackTag = new CompoundTag();
        storage.getItemStack().m_41739_(stackTag);
        compound.m_128365_(TAG_STACK, (Tag)stackTag);
        compound.m_128405_(TAG_SIZE, storage.getAmount());
        compound.m_128379_(TAG_SHOULDIGNOREDAMAGE, storage.ignoreDamageValue());
        compound.m_128379_(TAG_SHOULDIGNORENBT, storage.ignoreNBT());
        return compound;
    }

    @Override
    @NotNull
    public ItemStorage deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(TAG_STACK));
        int size = nbt.m_128451_(TAG_SIZE);
        boolean ignoreNBT = nbt.m_128471_(TAG_SHOULDIGNORENBT);
        boolean ignoreDamage = nbt.m_128471_(TAG_SHOULDIGNOREDAMAGE);
        return this.getNewInstance(stack, size, ignoreDamage, ignoreNBT);
    }

    @Override
    public void serialize(IFactoryController controller, ItemStorage input, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130055_(input.getItemStack());
        packetBuffer.m_130130_(input.getAmount());
        packetBuffer.writeBoolean(input.ignoreDamageValue());
        packetBuffer.writeBoolean(input.ignoreNBT());
    }

    @Override
    public ItemStorage deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        ItemStack stack = buffer.m_130267_();
        int size = buffer.m_130242_();
        boolean ignoreDamage = buffer.readBoolean();
        boolean ignoreNBT = buffer.readBoolean();
        return this.getNewInstance(stack, size, ignoreDamage, ignoreNBT);
    }

    @Override
    public short getSerializationId() {
        return 27;
    }
}

