/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.ai.util.StudyItem;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BuildingLibrary
extends AbstractBuilding {
    private static final String LIBRARY_HUT_NAME = "library";
    private final List<BlockPos> bookCases = new ArrayList<BlockPos>();
    private static final int MAX_BUILDING_LEVEL = 5;
    private final Random random = new Random();
    private final List<StudyItem> studyItems = this.parseFromConfig();

    public BuildingLibrary(IColony c, BlockPos l) {
        super(c, l);
    }

    private List<StudyItem> parseFromConfig() {
        ArrayList<StudyItem> studyItemList = new ArrayList<StudyItem>();
        for (String entry : (List)MineColonies.getConfig().getServer().configListStudyItems.get()) {
            try {
                String[] entries = entry.split(";");
                if (entries.length < 3) {
                    Log.getLogger().info("Minecolonies: Parsing config for study items for Library failed for entry:" + entry);
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entries[0]));
                int skillChance = Integer.parseInt(entries[1]);
                int breakChance = Integer.parseInt(entries[2]);
                if (item == null || skillChance < 100 || skillChance > 1000 || breakChance > 100 || breakChance < 0) {
                    Log.getLogger().info("Minecolonies: Parsing config for study items for Library failed for entry:" + entry);
                    continue;
                }
                studyItemList.add(new StudyItem(item, skillChance, breakChance));
                this.keepX.put(itemStack -> itemStack.m_41720_() == item, new Tuple((Object)(breakChance < 5 ? 5 : breakChance), (Object)true));
            }
            catch (ClassCastException | NumberFormatException e) {
                Log.getLogger().info("Minecolonies: Parsing config for study items for Library failed for entry:" + entry + " Exception:" + e.getMessage());
            }
        }
        return studyItemList;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LIBRARY_HUT_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag furnaceTagList = compound.m_128437_("bookcase", 10);
        for (int i = 0; i < furnaceTagList.size(); ++i) {
            this.bookCases.add(NbtUtils.m_129239_((CompoundTag)furnaceTagList.m_128728_(i).m_128469_("pos")));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag bookcaseTagList = new ListTag();
        for (BlockPos entry : this.bookCases) {
            @NotNull CompoundTag bookCompound = new CompoundTag();
            bookCompound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry));
            bookcaseTagList.add((Object)bookCompound);
        }
        compound.m_128365_("bookcase", (Tag)bookcaseTagList);
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(block, pos, world);
        if (block.m_49966_().m_204336_(Tags.Blocks.BOOKSHELVES)) {
            this.bookCases.add(pos);
        }
    }

    public BlockPos getRandomBookShelf() {
        if (this.bookCases.isEmpty()) {
            return this.getPosition();
        }
        BlockPos returnPos = this.bookCases.get(this.random.nextInt(this.bookCases.size()));
        if (this.colony.getWorld().m_8055_(returnPos).m_204336_(Tags.Blocks.BOOKSHELVES)) {
            return returnPos;
        }
        this.bookCases.remove(returnPos);
        return this.getPosition();
    }

    public List<StudyItem> getStudyItems() {
        return this.studyItems;
    }
}

