/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.modules.settings.ICraftingSetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.coremod.colony.buildings.moduleviews.CraftingModuleView;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RecipeSetting
implements ICraftingSetting {
    protected IToken<?> currentIndex;
    protected final String craftingModuleId;

    public RecipeSetting(String craftingModuleId) {
        this.craftingModuleId = craftingModuleId;
    }

    public RecipeSetting(IToken<?> currentIndex, String craftingModuleId) {
        this.currentIndex = currentIndex;
        this.craftingModuleId = craftingModuleId;
    }

    @Override
    public IRecipeStorage getValue(IBuilding building) {
        ICraftingBuildingModule craftingModule = (ICraftingBuildingModule)building.getModuleMatching(ICraftingBuildingModule.class, m -> m.getId().equals(this.craftingModuleId));
        for (IToken<?> token : craftingModule.getRecipes()) {
            if (!token.equals(this.currentIndex)) continue;
            return IColonyManager.getInstance().getRecipeManager().getRecipe(this.currentIndex);
        }
        this.currentIndex = ((ICraftingBuildingModule)building.getFirstModuleOccurance(ICraftingBuildingModule.class)).getRecipes().get(0);
        return IColonyManager.getInstance().getRecipeManager().getRecipe(this.currentIndex);
    }

    @Override
    public IRecipeStorage getValue(IBuildingView building) {
        CraftingModuleView craftingModule = building.getModuleViewMatching(CraftingModuleView.class, m -> m.getId().equals(this.craftingModuleId));
        for (IRecipeStorage recipe : craftingModule.getRecipes()) {
            if (!recipe.getToken().equals(this.currentIndex)) continue;
            return recipe;
        }
        this.currentIndex = craftingModule.getRecipes().get(0).getToken();
        return craftingModule.getRecipes().get(0);
    }

    @Override
    public List<ItemStack> getSettings(IBuilding building) {
        ArrayList<ItemStack> settings = new ArrayList<ItemStack>();
        for (IToken<?> token : ((ICraftingBuildingModule)building.getFirstModuleOccurance(ICraftingBuildingModule.class)).getRecipes()) {
            settings.add(IColonyManager.getInstance().getRecipeManager().getRecipe(token).getPrimaryOutput());
        }
        return new ArrayList<ItemStack>(settings);
    }

    @Override
    public List<ItemStack> getSettings(IBuildingView building) {
        ArrayList<ItemStack> settings = new ArrayList<ItemStack>();
        for (IRecipeStorage recipe : building.getModuleView(CraftingModuleView.class).getRecipes()) {
            settings.add(recipe.getPrimaryOutput());
        }
        return new ArrayList<ItemStack>(settings);
    }

    @Override
    public ResourceLocation getLayoutItem() {
        return new ResourceLocation("minecolonies:gui/layouthuts/layoutcraftingsetting.xml");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(input -> {
            int newIndex;
            List<IRecipeStorage> list = building.getModuleView(CraftingModuleView.class).getRecipes();
            int currentIntIndex = 0;
            int index = 0;
            for (IRecipeStorage recipe : list) {
                if (recipe.getToken().equals(this.currentIndex)) {
                    currentIntIndex = index;
                    break;
                }
                ++index;
            }
            if ((newIndex = currentIntIndex + 1) >= list.size()) {
                newIndex = 0;
            }
            this.currentIndex = list.get(newIndex).getToken();
            settingsModuleView.trigger(key);
        });
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        IRecipeStorage stack = this.getValue(building);
        ButtonImage triggerButton = (ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class);
        triggerButton.setEnabled(this.isActive(settingsModuleView));
        triggerButton.setText(Component.m_237115_((String)stack.getPrimaryOutput().m_41778_()));
        this.setInActiveHoverPane((Pane)triggerButton, settingsModuleView);
        ((ItemIcon)pane.findPaneOfTypeByID("iconto", ItemIcon.class)).setItem(stack.getPrimaryOutput());
        ((ItemIcon)pane.findPaneOfTypeByID("iconfrom", ItemIcon.class)).setItem(stack.getCleanedInput().get(0).getItemStack());
    }

    @Override
    public void set(IRecipeStorage value) {
        this.currentIndex = value.getToken();
    }

    @Override
    public boolean isActive(ISettingsModule module) {
        ICraftingBuildingModule craftingModule = (ICraftingBuildingModule)module.getBuilding().getModuleMatching(ICraftingBuildingModule.class, m -> m.getId().equals(this.craftingModuleId));
        return !craftingModule.getRecipes().isEmpty();
    }

    @Override
    public boolean isActive(ISettingsModuleView module) {
        CraftingModuleView craftingModule = module.getBuildingView().getModuleViewMatching(CraftingModuleView.class, m -> m.getId().equals(this.craftingModuleId));
        return craftingModule != null && !craftingModule.getRecipes().isEmpty();
    }

    @Override
    public boolean shouldHideWhenInactive() {
        return true;
    }

    @Override
    public void copyValue(ISetting setting) {
        if (setting instanceof RecipeSetting) {
            RecipeSetting other = (RecipeSetting)setting;
            this.currentIndex = other.currentIndex;
        }
    }
}

