/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IAltersBuildingFootprint;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.JobQuarrier;
import com.minecolonies.coremod.colony.requestsystem.resolvers.StationRequestResolver;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuarryModule
extends AbstractAssignedCitizenModule
implements IAssignsJob,
IBuildingEventsModule,
ITickingModule,
IPersistentModule,
ICreatesResolversModule,
IAltersBuildingFootprint {
    private boolean isFinished = false;
    private final int height;

    public QuarryModule(int height) {
        this.height = height;
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (!this.isFull() && this.building.getBuildingLevel() > 0 && this.building.isBuilt() && (this.getHiringMode() == HiringMode.DEFAULT && !this.building.getColony().isManualHiring() || this.getHiringMode() == HiringMode.AUTO)) {
            for (ICitizenData data : colony.getCitizenManager().getCitizens()) {
                if (!(data.getJob() instanceof JobQuarrier) || this.hasAssignedCitizen(data) || ((JobQuarrier)data.getJob()).findQuarry() != null) continue;
                this.assignCitizen(data);
            }
        }
        for (ICitizenData citizenData : new ArrayList<ICitizenData>(this.getAssignedCitizen())) {
            if (citizenData.getJob() instanceof JobQuarrier) continue;
            this.removeCitizen(citizenData);
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        int[] residentIds;
        super.deserializeNBT(compound);
        CompoundTag quarryCompound = compound.m_128469_(this.getModuleSerializationIdentifier());
        for (int citizenId : residentIds = quarryCompound.m_128465_("miners")) {
            ICitizenData citizen = this.building.getColony().getCitizenManager().getCivilian(citizenId);
            if (citizen == null) continue;
            this.assignCitizen(citizen);
        }
        this.isFinished = quarryCompound.m_128471_("isfinished");
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        CompoundTag quarrycompound;
        super.serializeNBT(compound);
        CompoundTag compoundTag = quarrycompound = compound.m_128441_(this.getModuleSerializationIdentifier()) ? compound.m_128469_(this.getModuleSerializationIdentifier()) : new CompoundTag();
        if (!this.assignedCitizen.isEmpty()) {
            int[] residentIds = new int[this.assignedCitizen.size()];
            for (int i = 0; i < this.assignedCitizen.size(); ++i) {
                residentIds[i] = ((ICitizenData)this.assignedCitizen.get(i)).getId();
            }
            quarrycompound.m_128385_("miners", residentIds);
        }
        compound.m_128365_(this.getModuleSerializationIdentifier(), (Tag)quarrycompound);
        quarrycompound.m_128379_("isfinished", this.isFinished);
    }

    @Override
    public void onRemoval(ICitizenData citizen) {
        this.resetProgress(citizen);
    }

    @Override
    public void onAssignment(ICitizenData citizen) {
        this.resetProgress(citizen);
    }

    private void resetProgress(ICitizenData citizen) {
        @Nullable IBuilding building = citizen.getWorkBuilding();
        if (building instanceof BuildingMiner) {
            ((BuildingMiner)building).setProgressPos(null, null);
        }
    }

    @Override
    public int getModuleMax() {
        return 1;
    }

    @Override
    public JobEntry getJobEntry() {
        return (JobEntry)ModJobs.quarrier.get();
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished() {
        this.isFinished = true;
        this.markDirty();
    }

    @Override
    public List<IRequestResolver<?>> createResolvers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new StationRequestResolver(this.building.getRequester().getLocation(), this.building.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    protected String getModuleSerializationIdentifier() {
        return "quarryassignment";
    }

    @Override
    public Tuple<BlockPos, BlockPos> getAdditionalCorners() {
        return new Tuple((Object)new BlockPos(0, this.height, 0), (Object)new BlockPos(0, 0, 0));
    }
}

