/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render.worldevent;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.StructureClientHandler;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.RotationMirror;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.client.ModKeyMappings;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.coremod.client.render.worldevent.ColonyWorldRenderMacros;
import com.minecolonies.coremod.client.render.worldevent.WorldEventContext;
import com.minecolonies.coremod.colony.workorders.view.WorkOrderBuildingView;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyBlueprintRenderer {
    private static final BlockPos INVALID_POS = BlockPos.f_121853_.m_6625_(500);
    private static final double CACHE_RESET_RANGE = 12.5;
    private static Map<BlueprintCacheKey, List<BlockPos>> blueprintRenderCache = new HashMap<BlueprintCacheKey, List<BlockPos>>();
    private static Map<BlockPos, BoxRenderData> boxRenderCache = new HashMap<BlockPos, BoxRenderData>();
    private static final LoadingCache<BlueprintCacheKey, BlueprintPreviewData> blueprintDataCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(2L)).softValues().build(CacheLoader.from(ColonyBlueprintRenderer::makeBlueprintPreview));
    private static BlockPos lastCacheRebuild = null;
    private static boolean shouldRenderBlueprints = true;
    private static final Map<BlockPos, PendingRenderData> pendingBoxes = new HashMap<BlockPos, PendingRenderData>();
    private static final List<IRenderBlueprintRule> renderRules = new ArrayList<IRenderBlueprintRule>();

    public static void invalidateCache() {
        lastCacheRebuild = null;
    }

    public static boolean willRenderBlueprints() {
        return shouldRenderBlueprints;
    }

    static void renderBlueprints(WorldEventContext ctx) {
        if (((KeyMapping)ModKeyMappings.TOGGLE_GOGGLES.get()).m_90859_()) {
            shouldRenderBlueprints = !shouldRenderBlueprints;
            ctx.clientPlayer.m_6330_(SoundEvents.f_12216_, SoundSource.NEUTRAL, 1.0f, shouldRenderBlueprints ? 0.75f : 0.25f);
        }
        if (!ctx.hasNearestColony()) {
            blueprintRenderCache.clear();
            boxRenderCache.clear();
            lastCacheRebuild = null;
            return;
        }
        ArrayList<IRenderBlueprintRule> activeRules = new ArrayList<IRenderBlueprintRule>();
        for (IRenderBlueprintRule rule : renderRules) {
            if (!rule.isEnabled(ctx)) continue;
            activeRules.add(rule);
        }
        if (activeRules.isEmpty()) {
            blueprintRenderCache.clear();
            boxRenderCache.clear();
            lastCacheRebuild = null;
            return;
        }
        BlockPos activePosition = ctx.clientPlayer.m_20183_();
        if (lastCacheRebuild == null || !lastCacheRebuild.m_123314_((Vec3i)activePosition, 12.5)) {
            ColonyBlueprintRenderer.rebuildCache(ctx, activeRules);
            lastCacheRebuild = activePosition;
        }
        if (Minecraft.m_91087_().f_91073_.m_46467_() % 20L == 0L) {
            ColonyBlueprintRenderer.processPendingBlueprints();
        }
        if (shouldRenderBlueprints) {
            for (Map.Entry<BlueprintCacheKey, List<BlockPos>> entry : blueprintRenderCache.entrySet()) {
                BlueprintPreviewData data = (BlueprintPreviewData)blueprintDataCache.getUnchecked((Object)entry.getKey());
                StructureClientHandler.renderStructureAtPosList((BlueprintPreviewData)data, (float)ctx.partialTicks, entry.getValue(), (PoseStack)ctx.poseStack);
            }
        }
    }

    static void renderBoxes(WorldEventContext ctx) {
        for (Map.Entry<BlockPos, BoxRenderData> entry : boxRenderCache.entrySet()) {
            BlockPos pos2;
            ICitizenDataView citizen;
            BoxRenderData buildingData = entry.getValue();
            if (buildingData.box().getPos1() != INVALID_POS) {
                ColonyWorldRenderMacros.renderLineBox(ctx.poseStack, ctx.bufferSource, new AABB(buildingData.box().getPos1(), buildingData.box().getPos2().m_7918_(1, 1, 1)), 0.08f, -16776961, false);
            }
            buildingData.box().getAnchor().ifPresent(pos -> {
                if (ctx.clientPlayer.m_6144_()) {
                    ColonyWorldRenderMacros.renderLineBox(ctx.poseStack, ctx.bufferSource, new AABB(pos), 0.02f, -65536, true);
                }
            });
            if (ctx.nearestColony == null || buildingData.builder() == 0 || !ctx.clientPlayer.m_6144_() || (citizen = ctx.nearestColony.getCitizen(buildingData.builder())) == null || (pos2 = citizen.getStatusPosition()) == null) continue;
            ColonyWorldRenderMacros.renderLineBox(ctx.poseStack, ctx.bufferSource, new AABB(pos2), 0.02f, -16711936, true);
        }
        ColonyWorldRenderMacros.endRenderLineBox(ctx.bufferSource);
    }

    private static void rebuildCache(WorldEventContext ctx, List<IRenderBlueprintRule> rules) {
        Collections.reverse(rules);
        HashMap<BlockPos, PendingRenderData> desired = new HashMap<BlockPos, PendingRenderData>();
        for (IRenderBlueprintRule rule : rules) {
            desired.putAll(rule.getDesiredBlueprints(ctx));
        }
        HashMap<BlueprintCacheKey, List<BlockPos>> newBlueprints = new HashMap<BlueprintCacheKey, List<BlockPos>>();
        HashMap<BlockPos, BoxRenderData> newBoxes = new HashMap<BlockPos, BoxRenderData>();
        for (Map.Entry entry : desired.entrySet()) {
            BoxRenderData newBox;
            if (((PendingRenderData)entry.getValue()).blueprint() != null && !((PendingRenderData)entry.getValue()).boxOnly()) {
                List posList = newBlueprints.computeIfAbsent(((PendingRenderData)entry.getValue()).blueprint(), k -> new ArrayList());
                posList.add((BlockPos)entry.getKey());
            }
            if ((newBox = ColonyBlueprintRenderer.tryLoadBox((PendingRenderData)entry.getValue())) != null) {
                newBoxes.put((BlockPos)entry.getKey(), newBox);
                continue;
            }
            pendingBoxes.put((BlockPos)entry.getKey(), (PendingRenderData)entry.getValue());
            BoxRenderData oldBox = boxRenderCache.getOrDefault(entry.getKey(), null);
            if (oldBox == null) continue;
            newBoxes.put((BlockPos)entry.getKey(), oldBox);
        }
        blueprintRenderCache = newBlueprints;
        boxRenderCache = newBoxes;
    }

    @Nullable
    private static BoxRenderData tryLoadBox(@NotNull PendingRenderData data) {
        if (data.blueprint() == null) {
            if (data.boxOnly() && data.hasAnchor()) {
                BoxPreviewData box = new BoxPreviewData(INVALID_POS, INVALID_POS, Optional.of(data.pos()));
                return new BoxRenderData(box, 0);
            }
            return new BoxRenderData(null, 0);
        }
        BlueprintPreviewData blueprintData = (BlueprintPreviewData)blueprintDataCache.getUnchecked((Object)data.blueprint());
        Blueprint localBlueprint = blueprintData.getBlueprint();
        if (localBlueprint == null) {
            return null;
        }
        if (blueprintData.isEmpty()) {
            return new BoxRenderData(null, 0);
        }
        BlockPos primaryOffset = localBlueprint.getPrimaryBlockOffset();
        BlockPos boxStartPos = data.pos().m_121996_((Vec3i)primaryOffset);
        BlockPos boxEndPos = boxStartPos.m_7918_(localBlueprint.getSizeX() - 1, localBlueprint.getSizeY() - 1, localBlueprint.getSizeZ() - 1);
        BoxPreviewData box = new BoxPreviewData(boxStartPos, boxEndPos, data.hasAnchor() ? Optional.of(data.pos()) : Optional.empty());
        return new BoxRenderData(box, data.builder());
    }

    private static void processPendingBlueprints() {
        Iterator<Map.Entry<BlockPos, PendingRenderData>> iterator = pendingBoxes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, PendingRenderData> entry = iterator.next();
            BoxRenderData box = ColonyBlueprintRenderer.tryLoadBox(entry.getValue());
            if (box == null) continue;
            if (box.box() != null || box.builder() != 0) {
                boxRenderCache.put(entry.getKey(), box);
            }
            iterator.remove();
        }
    }

    @NotNull
    private static BlueprintPreviewData makeBlueprintPreview(@NotNull BlueprintCacheKey key) {
        Future blueprintFuture = StructurePacks.getBlueprintFuture((String)key.packName(), (String)key.path());
        BlueprintPreviewData blueprintPreviewData = new BlueprintPreviewData(false);
        blueprintPreviewData.setBlueprintFuture(blueprintFuture);
        blueprintPreviewData.setPos(BlockPos.f_121853_);
        blueprintPreviewData.setRotationMirror(key.orientation());
        return blueprintPreviewData;
    }

    static {
        renderRules.add(new NearBuildPreview());
        renderRules.add(new BuildGoggles());
    }

    private static interface IRenderBlueprintRule {
        public boolean isEnabled(WorldEventContext var1);

        public Map<BlockPos, PendingRenderData> getDesiredBlueprints(WorldEventContext var1);
    }

    private record BlueprintCacheKey(@NotNull String packName, @NotNull String path, RotationMirror orientation) {
    }

    private record BoxRenderData(@Nullable BoxPreviewData box, int builder) {
    }

    private record PendingRenderData(@Nullable BlueprintCacheKey blueprint, @NotNull BlockPos pos, int builder, boolean boxOnly, boolean hasAnchor) {
    }

    private static class NearBuildPreview
    implements IRenderBlueprintRule {
        private NearBuildPreview() {
        }

        @Override
        public boolean isEnabled(WorldEventContext ctx) {
            return RenderingCache.getOrCreateBlueprintPreviewData((String)"blueprint").getBlueprint() != null && (Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getClient().neighborbuildingrendering.get() != false && ctx.mainHandItem.m_41720_() == ModItems.buildTool.get();
        }

        @Override
        public Map<BlockPos, PendingRenderData> getDesiredBlueprints(WorldEventContext ctx) {
            HashMap<BlockPos, PendingRenderData> desired = new HashMap<BlockPos, PendingRenderData>();
            BlockPos activePosition = RenderingCache.getOrCreateBlueprintPreviewData((String)"blueprint").getPos();
            Blueprint blueprint = RenderingCache.getOrCreateBlueprintPreviewData((String)"blueprint").getBlueprint();
            BlockPos zeroPos = activePosition.m_121996_((Vec3i)blueprint.getPrimaryBlockOffset());
            AABB blueprintAABB = new AABB(zeroPos, zeroPos.m_7918_(blueprint.getSizeX() - 1, blueprint.getSizeY() - 1, blueprint.getSizeZ() - 1)).m_82400_((double)(2 + (Integer)MinecoloniesAPIProxy.getInstance().getConfig().getClient().neighborbuildingrange.get()));
            for (IBuildingView buildingView : ctx.nearestColony.getBuildings()) {
                BlockPos cornerB;
                TileEntityColonyBuilding tileEntityColonyBuilding;
                Tuple corners;
                BlockPos cornerA;
                BlockPos currentPosition = buildingView.getPosition();
                BlockEntity blockEntity = ctx.clientLevel.m_7702_(currentPosition);
                if (!(blockEntity instanceof TileEntityColonyBuilding) || !blueprintAABB.m_82381_(new AABB(cornerA = (BlockPos)(corners = (tileEntityColonyBuilding = (TileEntityColonyBuilding)blockEntity).getInWorldCorners()).m_14418_(), cornerB = (BlockPos)corners.m_14419_()))) continue;
                Object schemPath = buildingView.getStructurePath();
                schemPath = ((String)schemPath).replace(".blueprint", "");
                schemPath = ((String)schemPath).substring(0, ((String)schemPath).length() - 1) + buildingView.getBuildingMaxLevel() + ".blueprint";
                String structurePack = buildingView.getStructurePack();
                BlueprintCacheKey key = new BlueprintCacheKey(structurePack, (String)schemPath, RotationMirror.of((Rotation)BlockPosUtil.getRotationFromRotations(buildingView.getRotation()), (Mirror)(buildingView.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE)));
                desired.put(currentPosition, new PendingRenderData(key, currentPosition, 0, buildingView.getBuildingLevel() >= buildingView.getBuildingMaxLevel(), true));
            }
            return desired;
        }
    }

    private static class BuildGoggles
    implements IRenderBlueprintRule {
        private BuildGoggles() {
        }

        @Override
        public boolean isEnabled(WorldEventContext ctx) {
            return ctx.clientPlayer.m_6844_(EquipmentSlot.HEAD).m_150930_(com.minecolonies.api.items.ModItems.buildGoggles);
        }

        @Override
        public Map<BlockPos, PendingRenderData> getDesiredBlueprints(WorldEventContext ctx) {
            double range = MathUtils.square(((Integer)MinecoloniesAPIProxy.getInstance().getConfig().getClient().buildgogglerange.get()).intValue());
            HashMap<BlockPos, PendingRenderData> desired = new HashMap<BlockPos, PendingRenderData>();
            for (IWorkOrderView workOrder : ctx.nearestColony.getWorkOrders()) {
                if (!(workOrder.getLocation().m_123331_((Vec3i)ctx.clientPlayer.m_20183_()) < range)) continue;
                int builder = this.getBuilderId(ctx.nearestColony, workOrder.getClaimedBy());
                BlueprintCacheKey key = new BlueprintCacheKey(workOrder.getPackName(), workOrder.getStructurePath(), RotationMirror.of((Rotation)BlockPosUtil.getRotationFromRotations(workOrder.getRotation()), (Mirror)(workOrder.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE)));
                desired.put(workOrder.getLocation(), new PendingRenderData(key, workOrder.getLocation(), builder, workOrder.getWorkOrderType() == WorkOrderType.REMOVE, workOrder instanceof WorkOrderBuildingView));
            }
            for (IBuildingView building : ctx.nearestColony.getBuildings()) {
                if (desired.containsKey(building.getPosition()) || building.getBuildingLevel() != 0 || building.getBuildingMaxLevel() <= 0 || !(building.getPosition().m_123331_((Vec3i)ctx.clientPlayer.m_20183_()) < range)) continue;
                desired.put(building.getPosition(), new PendingRenderData(null, building.getPosition(), 0, true, true));
            }
            return desired;
        }

        private int getBuilderId(IColonyView colony, BlockPos builderPos) {
            Set<Integer> builders;
            IBuildingView builderView;
            if (builderPos != null && !builderPos.equals((Object)BlockPos.f_121853_) && (builderView = colony.getBuilding(builderPos)) != null && !(builders = builderView.getAllAssignedCitizens()).isEmpty()) {
                return builders.iterator().next();
            }
            return 0;
        }
    }
}

