/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CitizenArmorLayer<T extends AbstractEntityCitizen, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends HumanoidArmorLayer<T, M, A> {
    public CitizenArmorLayer(RenderLayerParent<T, M> parentLayer, A innerModel, A outerModel) {
        super(parentLayer, innerModel, outerModel);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int light, @NotNull T citizen, float ignore_1, float ignore_2, float ignore_3, float ignore_4, float ignore_5, float ignore_6) {
        if (((AbstractEntityCitizen)citizen).getCitizenDataView() == null) {
            return;
        }
        if (((AbstractEntityCitizen)citizen).getCitizenDataView().getInventory() == null) {
            return;
        }
        this.renderArmorPiece(poseStack, bufferSource, citizen, EquipmentSlot.CHEST, light, this.m_117078_(EquipmentSlot.CHEST));
        this.renderArmorPiece(poseStack, bufferSource, citizen, EquipmentSlot.LEGS, light, this.m_117078_(EquipmentSlot.LEGS));
        this.renderArmorPiece(poseStack, bufferSource, citizen, EquipmentSlot.FEET, light, this.m_117078_(EquipmentSlot.FEET));
        this.renderArmorPiece(poseStack, bufferSource, citizen, EquipmentSlot.HEAD, light, this.m_117078_(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, T citizen, EquipmentSlot equipmentSlot, int light, A armor) {
        ArmorItem armoritem;
        Item armorItem;
        ItemStack itemstack = ((AbstractEntityCitizen)citizen).getCitizenDataView().getInventory().getArmorInSlot(equipmentSlot);
        if (itemstack.m_41619_()) {
            itemstack = citizen.m_6844_(equipmentSlot);
        }
        if ((armorItem = itemstack.m_41720_()) instanceof ArmorItem && (armoritem = (ArmorItem)armorItem).m_40402_() == equipmentSlot) {
            ((HumanoidModel)this.m_117386_()).m_102872_(armor);
            this.m_117125_((HumanoidModel)armor, equipmentSlot);
            Model model = this.getArmorModelHook((LivingEntity)citizen, itemstack, equipmentSlot, (HumanoidModel)armor);
            boolean flag = this.m_117128_(equipmentSlot);
            if (armoritem instanceof DyeableLeatherItem) {
                int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderModel(poseStack, bufferSource, light, armoritem, model, flag, f, f1, f2, this.getArmorResource((Entity)citizen, itemstack, equipmentSlot, null));
                this.renderModel(poseStack, bufferSource, light, armoritem, model, flag, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)citizen, itemstack, equipmentSlot, "overlay"));
            } else {
                this.renderModel(poseStack, bufferSource, light, armoritem, model, flag, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)citizen, itemstack, equipmentSlot, null));
            }
            if (itemstack.m_41790_()) {
                this.renderGlint(poseStack, bufferSource, light, model);
            }
        }
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource bufferSource, int light, ArmorItem armorItem, Model model, boolean ignore, float red, float green, float blue, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110431_((ResourceLocation)armorResource));
        model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    private void renderGlint(PoseStack poseStack, MultiBufferSource bufferSource, int light, Model model) {
        model.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110484_()), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

