/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.CompactColonyReference;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.commands.ClickEventWithExecutable;
import com.minecolonies.coremod.network.messages.server.colony.TeleportToColonyMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WindowAlliancePage
extends AbstractWindowTownHall {
    private final ScrollingList feudsList;
    private final ScrollingList alliesList = (ScrollingList)this.findPaneOfTypeByID("allies", ScrollingList.class);

    public WindowAlliancePage(BuildingTownHall.View building) {
        super(building, "layoutalliance.xml");
        this.feudsList = (ScrollingList)this.findPaneOfTypeByID("feuds", ScrollingList.class);
        this.registerButton("tp", this::teleportToColony);
        this.fillAlliesAndFeudsList();
    }

    private void teleportToColony(@NotNull Button button) {
        int row = this.alliesList.getListElementIndexByPane((Pane)button);
        CompactColonyReference ally = ((ITownHallView)this.building).getColony().getAllies().get(row);
        MessageUtils.format("com.minecolonies.coremod.gui.townhall.tp", ally.name).with(Style.f_131099_.m_131142_((ClickEvent)new ClickEventWithExecutable(ClickEvent.Action.RUN_COMMAND, "", () -> Network.getNetwork().sendToServer(new TeleportToColonyMessage(ally.dimension, ally.id))))).with(ChatFormatting.BOLD, ChatFormatting.GOLD).sendTo(new Player[]{Minecraft.m_91087_().f_91074_});
        this.close();
    }

    private void fillAlliesAndFeudsList() {
        this.alliesList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowAlliancePage.this.building).getColony().getAllies().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                CompactColonyReference colonyReference = ((ITownHallView)WindowAlliancePage.this.building).getColony().getAllies().get(index);
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.m_237113_((String)colonyReference.name));
                long distance = BlockPosUtil.getDistance2D(colonyReference.center, ((ITownHallView)WindowAlliancePage.this.building).getPosition());
                ((Text)rowPane.findPaneOfTypeByID("dist", Text.class)).setText(Component.m_237113_((String)((int)distance + "b")));
                Button button = (Button)rowPane.findPaneOfTypeByID("tp", Button.class);
                if (colonyReference.hasTownHall && (((ITownHallView)WindowAlliancePage.this.building).getBuildingLevel() < (Integer)MineColonies.getConfig().getServer().minThLevelToTeleport.get() || !((ITownHallView)WindowAlliancePage.this.building).canPlayerUseTP())) {
                    button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.townhall.toolow"));
                    button.disable();
                } else {
                    button.enable();
                }
            }
        });
        this.feudsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowAlliancePage.this.building).getColony().getFeuds().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                CompactColonyReference colonyReference = ((ITownHallView)WindowAlliancePage.this.building).getColony().getFeuds().get(index);
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.m_237113_((String)colonyReference.name));
                long distance = BlockPosUtil.getDistance2D(colonyReference.center, ((ITownHallView)WindowAlliancePage.this.building).getPosition());
                ((Text)rowPane.findPaneOfTypeByID("dist", Text.class)).setText(Component.m_237113_((String)String.valueOf((int)distance)));
            }
        });
    }

    @Override
    protected String getWindowId() {
        return "alliances";
    }
}

