/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.util.ItemStackUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerCraftingBrewingstand
extends AbstractContainerMenu {
    private final IItemHandler brewingStandInventory;
    private final Inventory playerInventory;
    public final BlockPos buildingPos;
    private String moduleId;

    public static ContainerCraftingBrewingstand fromFriendlyByteBuf(int windowId, Inventory inv, FriendlyByteBuf packetBuffer) {
        BlockPos tePos = packetBuffer.m_130135_();
        String moduleId = packetBuffer.m_130136_(Short.MAX_VALUE);
        return new ContainerCraftingBrewingstand(windowId, inv, tePos, moduleId);
    }

    public ContainerCraftingBrewingstand(int windowId, Inventory inv, BlockPos pos, String moduleId) {
        super((MenuType)ModContainers.craftingBrewingstand.get(), windowId);
        int i;
        this.moduleId = moduleId;
        this.brewingStandInventory = new IItemHandlerModifiable(){
            ItemStack ingredient = ItemStack.f_41583_;
            ItemStack potion = ItemStack.f_41583_;

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                if (!this.isItemValid(slot, stack) && !ItemStackUtils.isEmpty(stack)) {
                    return;
                }
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(1);
                if (slot == 3) {
                    this.ingredient = copy;
                } else {
                    this.potion = copy;
                }
            }

            public int getSlots() {
                return 4;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                if (slot == 3) {
                    return this.ingredient;
                }
                return this.potion;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack) && !ItemStackUtils.isEmpty(stack)) {
                    return stack;
                }
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(1);
                if (slot == 3) {
                    this.ingredient = copy;
                } else {
                    this.potion = copy;
                }
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 3) {
                    return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
                }
                if (slot >= 0 && slot < 3) {
                    return BrewingRecipeRegistry.isValidInput((ItemStack)stack);
                }
                return false;
            }
        };
        this.playerInventory = inv;
        this.buildingPos = pos;
        this.m_38897_((Slot)new SlotItemHandler(this.brewingStandInventory, 3, 79, 17));
        this.m_38897_((Slot)new InputItemHandler(this.brewingStandInventory, 0, 56, 51));
        this.m_38897_((Slot)new InputItemHandler(this.brewingStandInventory, 1, 79, 58));
        this.m_38897_((Slot)new InputItemHandler(this.brewingStandInventory, 2, 102, 51));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.playerInventory, i, 8 + i * 18, 142));
        }
    }

    public void m_150399_(int slotId, int clickedButton, ClickType mode, Player playerIn) {
        if (slotId >= 0 && slotId < this.brewingStandInventory.getSlots()) {
            if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP || mode == ClickType.QUICK_MOVE) {
                Slot slot = (Slot)this.f_38839_.get(slotId);
                this.handleSlotClick(slot, this.m_142621_());
            }
        } else {
            super.m_150399_(slotId, clickedButton, mode, this.playerInventory.f_35978_);
        }
    }

    public void setInput(ItemStack stack) {
        this.handleSlotClick(this.m_38853_(0), stack);
    }

    public void setContainer(ItemStack stack) {
        this.handleSlotClick(this.m_38853_(1), stack);
        this.handleSlotClick(this.m_38853_(2), stack);
        this.handleSlotClick(this.m_38853_(3), stack);
    }

    private ItemStack handleSlotClick(Slot slot, ItemStack stack) {
        if (stack.m_41613_() > 0) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            slot.m_5852_(copy);
        } else if (slot.m_7993_().m_41613_() > 0) {
            slot.m_5852_(ItemStack.f_41583_);
        }
        return slot.m_7993_().m_41777_();
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return true;
    }

    @NotNull
    public ItemStack m_7648_(Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            if (index < 3) {
                this.setContainer(ItemStack.f_41583_);
                return ItemStack.f_41583_;
            }
            if (index == 3) {
                this.setInput(ItemStack.f_41583_);
                return ItemStack.f_41583_;
            }
            if (BrewingRecipeRegistry.isValidIngredient((ItemStack)stack)) {
                this.setInput(stack);
                return ItemStack.f_41583_;
            }
            if (BrewingRecipeRegistry.isValidInput((ItemStack)stack) && stack.m_41613_() == 1) {
                this.setContainer(stack);
                return ItemStack.f_41583_;
            }
        }
        return ItemStack.f_41583_;
    }

    public Player getPlayer() {
        return this.playerInventory.f_35978_;
    }

    public Level getWorldObj() {
        return this.playerInventory.f_35978_.f_19853_;
    }

    public BlockPos getPos() {
        return this.buildingPos;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    private static class InputItemHandler
    extends SlotItemHandler {
        public InputItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public int m_6641_() {
            return 1;
        }

        @NotNull
        public ItemStack m_6201_(int par1) {
            return ItemStack.f_41583_;
        }

        public boolean m_5857_(@NotNull ItemStack par1ItemStack) {
            return true;
        }

        public boolean m_8010_(Player par1PlayerEntity) {
            return false;
        }
    }
}

