/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen;

import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.entity.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.sounds.SoundManager;
import com.minecolonies.api.util.SoundUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCivilianEntity
extends AbstractFastMinecoloniesEntity
implements Npc {
    private boolean canBeStuck = true;
    protected long nextPlayerCollisionTime = 0L;
    private SoundManager soundManager;

    protected AbstractCivilianEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        if (worldIn.f_46443_) {
            this.soundManager = new SoundManager((ClientLevel)worldIn);
        }
    }

    public abstract void setCivilianData(@Nullable ICivilianData var1);

    public abstract ICivilianData getCivilianData();

    public abstract void markDirty(int var1);

    public abstract int getCivilianID();

    public abstract void setCitizenId(int var1);

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.soundManager.tick();
        }
    }

    @Override
    public boolean m_21334_() {
        if (this.f_19797_ % 5 == this.randomVariance % 5) {
            return true;
        }
        if (this.m_21257_().isPresent()) {
            BlockPos pos = (BlockPos)this.m_21257_().get();
            BlockState state = this.f_19853_.m_8055_((BlockPos)this.m_21257_().get());
            return state.m_60734_().isBed(state, (BlockGetter)this.f_19853_, pos, (Entity)this);
        }
        return false;
    }

    public void m_7334_(@NotNull Entity entityIn) {
        if (entityIn instanceof ServerPlayer) {
            this.onPlayerCollide((Player)entityIn);
        }
        super.m_7334_(entityIn);
    }

    public void onPlayerCollide(Player player) {
        if (player.f_19853_.m_46467_() > this.nextPlayerCollisionTime) {
            this.nextPlayerCollisionTime = player.f_19853_.m_46467_() + 300L;
            this.m_21573_().m_26573_();
            this.m_21563_().m_148051_((Entity)player);
            SoundUtils.playSoundAtCitizenWith(this.f_19853_, this.m_20183_(), EventType.GREETING, this.getCivilianData());
        }
    }

    public SoundManager getSoundManager() {
        return this.soundManager;
    }
}

