/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.ai.statemachine.tickratestatemachine;

import com.minecolonies.api.entity.ai.statemachine.basestatemachine.BasicStateMachine;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickingTransition;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class TickRateStateMachine<S extends IState>
extends BasicStateMachine<ITickingTransition<S>, S>
implements ITickRateStateMachine<S> {
    public static double slownessFactor = 1.0;
    private int tickCounter = 0;
    private int tickRate = 1;
    private int tickRateCounter = 0;
    private ITickingTransition<S> executedTransition = null;
    private final List<ITickingTransition<S>> aiBlockingTransitions = new ArrayList<ITickingTransition<S>>();
    private final List<ITickingTransition<S>> stateBlockingTransitions;
    private final List<ITickingTransition<S>> eventTransitions;

    public TickRateStateMachine(@NotNull S initialState, @NotNull Consumer<RuntimeException> exceptionHandler) {
        super(initialState, exceptionHandler);
        this.eventTransitionMap.put(AIBlockingEventType.AI_BLOCKING, this.aiBlockingTransitions);
        this.stateBlockingTransitions = new ArrayList<ITickingTransition<S>>();
        this.eventTransitionMap.put(AIBlockingEventType.STATE_BLOCKING, this.stateBlockingTransitions);
        this.eventTransitions = new ArrayList<ITickingTransition<S>>();
        this.eventTransitionMap.put(AIBlockingEventType.EVENT, this.eventTransitions);
    }

    @Override
    public void tick() {
        int i;
        if (this.tickRateCounter > 1) {
            --this.tickRateCounter;
            return;
        }
        this.tickRateCounter = this.tickRate;
        int aiBlockingTransitionsSize = this.aiBlockingTransitions.size();
        for (i = 0; i < aiBlockingTransitionsSize; ++i) {
            if (!this.checkTransition(this.aiBlockingTransitions.get(i))) continue;
            return;
        }
        int eventTransitionsSize = this.eventTransitions.size();
        for (i = 0; i < eventTransitionsSize; ++i) {
            if (!this.checkTransition(this.eventTransitions.get(i))) continue;
            return;
        }
        int stateBlockingTransitionsSize = this.stateBlockingTransitions.size();
        for (i = 0; i < stateBlockingTransitionsSize; ++i) {
            if (!this.checkTransition(this.stateBlockingTransitions.get(i))) continue;
            return;
        }
        int currentStateTransitionsSize = this.currentStateTransitions.size();
        for (i = 0; i < currentStateTransitionsSize; ++i) {
            if (!this.checkTransition((ITickingTransition)this.currentStateTransitions.get(i))) continue;
            return;
        }
    }

    @Override
    public boolean checkTransition(@NotNull ITickingTransition<S> transition) {
        if (transition.countdownTicksToUpdate() > 0) {
            return false;
        }
        transition.setTicksToUpdate((int)((double)transition.getTickRate() / slownessFactor));
        this.executedTransition = transition;
        return super.checkTransition(transition);
    }

    @Override
    public int getTickRate() {
        return this.tickRate;
    }

    @Override
    public void setTickRate(int tickRate) {
        this.tickRate = tickRate;
        this.tickRateCounter = new Random().nextInt(tickRate);
    }

    @Override
    public void setCurrentDelay(int ticksToNext) {
        this.executedTransition.setTicksToUpdate(ticksToNext);
    }
}

