/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.quests.objectives;

import com.google.gson.JsonObject;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.quests.IDialogueObjectiveTemplate;
import com.minecolonies.api.quests.IObjectiveInstance;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.quests.objectives.DialogueObjectiveTemplateTemplate;
import com.minecolonies.coremod.quests.objectives.IBuildingUpgradeObjectiveTemplate;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildBuildingObjectiveTemplate
extends DialogueObjectiveTemplateTemplate
implements IBuildingUpgradeObjectiveTemplate {
    private final BuildingEntry buildingEntry;
    private final int nextObjective;
    private final boolean countExisting;
    private final int lvl;
    private final int qty;

    public BuildBuildingObjectiveTemplate(int target, BuildingEntry buildingEntry, int lvl, int qty, boolean countExisting, int nextObjective, List<Integer> rewards) {
        super(target, BuildBuildingObjectiveTemplate.buildDialogueTree(buildingEntry, qty, lvl, countExisting), rewards);
        this.lvl = lvl;
        this.qty = qty;
        this.countExisting = countExisting;
        this.nextObjective = nextObjective;
        this.buildingEntry = buildingEntry;
    }

    @NotNull
    private static IDialogueObjectiveTemplate.DialogueElement buildDialogueTree(BuildingEntry buildingEntry, int qty, int lvl, boolean countExisting) {
        MutableComponent text = countExisting ? (qty > 0 ? Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.buildbuilding.existing", (Object[])new Object[]{lvl, qty, Component.m_237115_((String)buildingEntry.getTranslationKey())}) : Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.buildbuilding.cumulative.existing", (Object[])new Object[]{lvl, Component.m_237115_((String)buildingEntry.getTranslationKey())})) : (qty > 0 ? Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.buildbuilding", (Object[])new Object[]{qty, lvl, Component.m_237115_((String)buildingEntry.getTranslationKey())}) : Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.buildbuilding.cumulative", (Object[])new Object[]{lvl, Component.m_237115_((String)buildingEntry.getTranslationKey())}));
        IDialogueObjectiveTemplate.AnswerElement answer1 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.later"), new IQuestDialogueAnswer.CloseUIDialogueAnswer());
        IDialogueObjectiveTemplate.AnswerElement answer2 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.cancel"), new IQuestDialogueAnswer.QuestCancellationDialogueAnswer());
        return new IDialogueObjectiveTemplate.DialogueElement((Component)text, List.of(answer1, answer2));
    }

    public static IQuestObjectiveTemplate createObjective(JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int target = details.get("target").getAsInt();
        BuildingEntry buildingEntry = (BuildingEntry)IMinecoloniesAPI.getInstance().getBuildingRegistry().getValue(new ResourceLocation(details.get("type").getAsString()));
        int level = details.get("lvl").getAsInt();
        int quantity = details.get("qty").getAsInt();
        boolean countExisting = details.get("count-existing").getAsBoolean();
        int nextObj = details.has("next-objective") ? details.get("next-objective").getAsInt() : -1;
        return new BuildBuildingObjectiveTemplate(target, buildingEntry, level, quantity, countExisting, nextObj, BuildBuildingObjectiveTemplate.parseRewards(jsonObject));
    }

    @Override
    public IObjectiveInstance startObjective(IQuestInstance colonyQuest) {
        super.startObjective(colonyQuest);
        if (this.checkForFulfillment(colonyQuest, new BuildingProgressInstance(false))) {
            return colonyQuest.advanceObjective(colonyQuest.getColony().getWorld().m_46003_(colonyQuest.getAssignedPlayer()), this.nextObjective);
        }
        if (colonyQuest.getColony() instanceof Colony) {
            colonyQuest.getColony().getBuildingManager().trackBuildingLevelUp(this.buildingEntry, colonyQuest);
        }
        return new BuildingProgressInstance(false);
    }

    @Override
    @Nullable
    public IObjectiveInstance createObjectiveInstance() {
        return new BuildingProgressInstance(false);
    }

    @Override
    public void onCancellation(IQuestInstance colonyQuest) {
        this.cleanupListener(colonyQuest);
    }

    private void cleanupListener(IQuestInstance colonyQuest) {
        if (colonyQuest.getColony() instanceof Colony) {
            colonyQuest.getColony().getBuildingManager().stopTrackingBuildingLevelUp(this.buildingEntry, colonyQuest);
        }
    }

    @Override
    public void onBuildingUpgrade(IObjectiveInstance progressData, IQuestInstance colonyQuest, int level) {
        if (progressData.isFulfilled()) {
            return;
        }
        if (this.qty > 0) {
            if (level >= this.lvl) {
                ++((BuildingProgressInstance)progressData).currentProgress;
            }
        } else {
            ++((BuildingProgressInstance)progressData).currentProgress;
        }
        if (this.checkForFulfillment(colonyQuest, (BuildingProgressInstance)progressData)) {
            this.cleanupListener(colonyQuest);
            colonyQuest.advanceObjective(colonyQuest.getColony().getWorld().m_46003_(colonyQuest.getAssignedPlayer()), this.nextObjective);
        }
    }

    private boolean checkForFulfillment(IQuestInstance colonyQuest, BuildingProgressInstance buildingBuildingProgressInstance) {
        if (this.countExisting) {
            if (this.qty > 0) {
                int count = 0;
                for (IBuilding building : colonyQuest.getColony().getBuildingManager().getBuildings().values()) {
                    if (building.getBuildingType() != this.buildingEntry || building.getBuildingLevel() < this.lvl) continue;
                    ++count;
                }
                return count > this.qty;
            }
            int count = 0;
            for (IBuilding building : colonyQuest.getColony().getBuildingManager().getBuildings().values()) {
                if (building.getBuildingType() != this.buildingEntry) continue;
                count += building.getBuildingLevel();
            }
            return count > this.lvl;
        }
        return buildingBuildingProgressInstance.currentProgress > this.qty;
    }

    @Override
    public void onWorldLoad(IQuestInstance colonyQuest) {
        super.onWorldLoad(colonyQuest);
        if (colonyQuest.getColony() instanceof Colony) {
            colonyQuest.getColony().getBuildingManager().trackBuildingLevelUp(this.buildingEntry, colonyQuest);
            @Nullable IObjectiveInstance objInstance = colonyQuest.getCurrentObjectiveInstance();
            if (objInstance instanceof BuildingProgressInstance && this.checkForFulfillment(colonyQuest, (BuildingProgressInstance)objInstance)) {
                ((BuildingProgressInstance)objInstance).finished = true;
                this.cleanupListener(colonyQuest);
                colonyQuest.advanceObjective(colonyQuest.getColony().getWorld().m_46003_(colonyQuest.getAssignedPlayer()), this.nextObjective);
            }
        }
    }

    public class BuildingProgressInstance
    implements IObjectiveInstance {
        private boolean finished = true;
        private int currentProgress = 0;

        public BuildingProgressInstance(boolean finished) {
        }

        @Override
        public boolean isFulfilled() {
            return this.finished;
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("quantity", this.currentProgress);
            compoundTag.m_128379_("finishedquests", this.finished);
            return compoundTag;
        }

        @Override
        public int getMissingQuantity() {
            return 0;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.currentProgress = nbt.m_128451_("quantity");
            this.finished = nbt.m_128471_("finishedquests");
        }
    }
}

