/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.worker;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import com.minecolonies.coremod.util.AdvancementUtils;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AddRemoveRecipeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private boolean remove;
    private IRecipeStorage storage;
    private String id;

    public AddRemoveRecipeMessage() {
    }

    public AddRemoveRecipeMessage(IBuildingView building, boolean remove, IRecipeStorage storage, String id) {
        super(building);
        this.remove = remove;
        this.storage = storage;
        this.id = id;
    }

    public AddRemoveRecipeMessage(IBuildingView building, List<ItemStorage> input, int gridSize, ItemStack primaryOutput, List<ItemStack> additionalOutputs, boolean remove, String id) {
        super(building);
        this.remove = remove;
        this.storage = gridSize == 1 ? (IRecipeStorage)StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput, Blocks.f_50094_}) : (IRecipeStorage)StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput, Blocks.f_50016_, null, null, null, additionalOutputs});
        this.id = id;
    }

    public AddRemoveRecipeMessage(IBuildingView building, List<ItemStorage> input, int gridSize, ItemStack primaryOutput, boolean remove, Block intermediary, String id) {
        super(building);
        this.remove = remove;
        if (gridSize == 1) {
            this.storage = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, gridSize, primaryOutput, intermediary});
        }
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.storage = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(buf);
        this.remove = buf.readBoolean();
        this.id = buf.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        StandardFactoryController.getInstance().serialize(buf, this.storage);
        buf.writeBoolean(this.remove);
        buf.m_130070_(this.id);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        ServerPlayer player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        AbstractCraftingBuildingModule module = (AbstractCraftingBuildingModule)building.getModuleMatching(AbstractCraftingBuildingModule.class, m -> m.getId().equals(this.id));
        if (this.remove) {
            module.removeRecipe(this.storage.getToken());
            SoundUtils.playSuccessSound((Player)player, player.m_20183_());
        } else {
            IToken<?> token = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(this.storage);
            if (!module.addRecipe(token)) {
                SoundUtils.playErrorSound((Player)player, player.m_20183_());
                MessageUtils.format("com.minecolonies.coremod.recipe.unable", Component.m_237115_((String)building.getBuildingDisplayName())).sendTo(new Player[]{player});
            } else {
                SoundUtils.playSuccessSound((Player)player, player.m_20183_());
                AdvancementUtils.TriggerAdvancementPlayersForColony(colony, playerMP -> AdvancementTriggers.BUILDING_ADD_RECIPE.trigger((ServerPlayer)playerMP, this.storage));
                MessageUtils.format("com.minecolonies.coremod.gui.recipe.done", new Object[0]).sendTo(new Player[]{player});
            }
        }
        building.markDirty();
    }
}

