/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.fields;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.coremod.colony.buildings.modules.FieldsModule;
import com.minecolonies.coremod.colony.fields.registry.FieldDataManager;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AssignFieldMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private FriendlyByteBuf fieldData;
    private boolean assign;

    public AssignFieldMessage() {
    }

    public AssignFieldMessage(IBuildingView building, IField field, boolean assign) {
        super(building);
        this.assign = assign;
        this.fieldData = FieldDataManager.fieldToBuffer(field);
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(this.assign);
        buf.writeBytes((ByteBuf)this.fieldData);
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.assign = buf.readBoolean();
        this.fieldData = new FriendlyByteBuf(Unpooled.buffer((int)buf.readableBytes()));
        buf.readBytes((ByteBuf)this.fieldData, buf.readableBytes());
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        IField parsedField = FieldDataManager.bufferToField(this.fieldData);
        colony.getBuildingManager().getField(otherField -> otherField.equals(parsedField)).ifPresent(field -> {
            if (this.assign) {
                building.getFirstOptionalModuleOccurance(FieldsModule.class).ifPresent(m -> m.assignField((IField)field));
            } else {
                building.getFirstOptionalModuleOccurance(FieldsModule.class).ifPresent(m -> m.freeField((IField)field));
            }
        });
    }
}

