/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.norsemenevent.NorsemenShipRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.PirateGroundRaidEvent;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class CommandRaidAll
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        return this.raidsExecute(context, "");
    }

    public int onSpecificExecute(CommandContext<CommandSourceStack> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        return this.raidsExecute(context, StringArgumentType.getString(context, (String)"raidtype"));
    }

    public int raidsExecute(CommandContext<CommandSourceStack> context, String raidType) {
        if (StringArgumentType.getString(context, (String)"raidtime").equals("now")) {
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                colony.getRaiderManager().raiderEvent(raidType);
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"com.minecolonies.command.raidtonight"), true);
            return 1;
        }
        if (StringArgumentType.getString(context, (String)"raidtime").equals("tonight")) {
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                colony.getRaiderManager().setRaidNextNight(true, raidType);
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"com.minecolonies.command.raidtonight"), true);
            return 1;
        }
        return 0;
    }

    @Override
    public String getName() {
        return "raid-All";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        ArrayList<String> raidTypes = new ArrayList<String>();
        for (ColonyEventTypeRegistryEntry type : IMinecoloniesAPI.getInstance().getColonyEventRegistry().getValues()) {
            if (type.getRegistryName().m_135815_().equals(PirateGroundRaidEvent.PIRATE_GROUND_RAID_EVENT_TYPE_ID.m_135815_()) || type.getRegistryName().m_135815_().equals(NorsemenShipRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.m_135815_())) continue;
            raidTypes.add(type.getRegistryName().m_135815_());
        }
        String[] opt = new String[]{"now", "tonight"};
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument("raidtime", StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])opt, (SuggestionsBuilder)builder)).then(IMCCommand.newArgument("raidtype", StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_((Iterable)raidTypes, (SuggestionsBuilder)builder)).executes(this::onSpecificExecute))).executes(this::checkPreConditionAndExecute));
    }
}

