/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.locations;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.location.ILocationFactory;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StaticLocation
implements ILocation {
    private static final int NUMBER_OR_CONTEXTS = 1;
    @NotNull
    private final BlockPos pos;
    private final ResourceKey<Level> dimension;

    public StaticLocation(@NotNull BlockPos pos, ResourceKey<Level> dimension) {
        this.pos = pos;
        this.dimension = dimension;
    }

    @Override
    @NotNull
    public BlockPos getInDimensionLocation() {
        return this.pos;
    }

    @Override
    @NotNull
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public boolean isReachableFromLocation(@NotNull ILocation location) {
        return location.getDimension() == this.getDimension();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StaticLocation)) {
            return false;
        }
        StaticLocation that = (StaticLocation)o;
        if (this.getDimension() != that.getDimension()) {
            return false;
        }
        return this.pos.equals((Object)that.pos);
    }

    public int hashCode() {
        int result = this.pos.hashCode();
        result = 31 * result + this.getDimension().m_135782_().toString().hashCode();
        return result;
    }

    public String toString() {
        return "Dim: " + this.dimension.m_135782_() + " " + this.pos.m_123341_() + " " + this.pos.m_123342_() + " " + this.pos.m_123343_() + " ";
    }

    public static void serialize(FriendlyByteBuf buffer, StaticLocation location) {
        buffer.m_130064_(location.pos);
        buffer.m_130070_(location.dimension.m_135782_().toString());
    }

    public static StaticLocation deserialize(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        ResourceLocation dimension = new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE));
        return new StaticLocation(pos, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension));
    }

    public static class Factory
    implements ILocationFactory<BlockPos, StaticLocation> {
        private static final String NBT_POS = "Pos";
        private static final String NBT_DIM = "Dim";

        @Override
        @NotNull
        public TypeToken<StaticLocation> getFactoryOutputType() {
            return TypeToken.of(StaticLocation.class);
        }

        @Override
        @NotNull
        public TypeToken<BlockPos> getFactoryInputType() {
            return TypeToken.of(BlockPos.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StaticLocation request) {
            CompoundTag compound = new CompoundTag();
            compound.m_128356_(NBT_POS, request.getInDimensionLocation().m_121878_());
            compound.m_128359_(NBT_DIM, request.getDimension().m_135782_().toString());
            return compound;
        }

        @Override
        @NotNull
        public StaticLocation deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            BlockPos pos = BlockPos.m_122022_((long)nbt.m_128454_(NBT_POS));
            String dim = nbt.m_128461_(NBT_DIM);
            return new StaticLocation(pos, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dim)));
        }

        @Override
        @NotNull
        public StaticLocation getNewInstance(@NotNull IFactoryController factoryController, @NotNull BlockPos blockPos, Object ... context) {
            if (context.length != 1) {
                throw new IllegalArgumentException("Unsupported context - Not the correct amount available. Needed is 1!");
            }
            if (!(context[0] instanceof ResourceKey)) {
                throw new IllegalArgumentException("Unsupported context - First context object is not a ResourceLocation. Provide an ResourceLocation as Dimension.");
            }
            return new StaticLocation(blockPos, (ResourceKey<Level>)((ResourceKey)context[0]));
        }

        @Override
        @NotNull
        public StaticLocation getNewInstance(@NotNull IFactoryController factoryController, @NotNull BlockPos input) {
            return new StaticLocation(input, (ResourceKey<Level>)Level.f_46428_);
        }

        @Override
        public void serialize(@NotNull IFactoryController controller, @NotNull StaticLocation input, FriendlyByteBuf packetBuffer) {
            StaticLocation.serialize(packetBuffer, input);
        }

        @Override
        @NotNull
        public StaticLocation deserialize(@NotNull IFactoryController controller, @NotNull FriendlyByteBuf buffer) throws Throwable {
            return StaticLocation.deserialize(buffer);
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.STATIC_LOCATION_ID;
        }
    }
}

