/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJob<AI extends AbstractAISkeleton<J>, J extends AbstractJob<AI, J>>
implements IJob<AI> {
    private static final String TAG_ASYNC_REQUESTS = "asyncRequests";
    private static final String TAG_ACTIONS_DONE = "actionsDone";
    private JobEntry entry;
    private int actionsDone = 0;
    private final ICitizenData citizen;
    private String nameTag = "";
    private final Set<IToken<?>> asyncRequests = new HashSet();
    private boolean searchedForFoodToday;

    public AbstractJob(ICitizenData entity) {
        this.citizen = entity;
    }

    @Override
    public boolean pickupSuccess(@NotNull ItemStack pickedUpStack) {
        return true;
    }

    @Override
    public ResourceLocation getModel() {
        return ModModelTypes.CITIZEN_ID;
    }

    @Override
    public IColony getColony() {
        return this.citizen.getColony();
    }

    @Override
    public void setRegistryEntry(JobEntry jobEntry) {
        this.entry = jobEntry;
    }

    @Override
    public final JobEntry getJobRegistryEntry() {
        return this.entry;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("type", this.getJobRegistryEntry().getKey().toString());
        compound.m_128365_(TAG_ASYNC_REQUESTS, (Tag)this.getAsyncRequests().stream().filter(token -> this.getColony().getRequestManager().getRequestForToken((IToken<?>)token) != null).map(StandardFactoryController.getInstance()::serialize).collect(NBTUtils.toListNBT()));
        compound.m_128405_(TAG_ACTIONS_DONE, this.actionsDone);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.asyncRequests.clear();
        if (compound.m_128441_(TAG_ASYNC_REQUESTS)) {
            this.asyncRequests.addAll(NBTUtils.streamCompound(compound.m_128437_(TAG_ASYNC_REQUESTS, 10)).map(StandardFactoryController.getInstance()::deserialize).map(o -> (IToken)o).collect(Collectors.toSet()));
        }
        if (compound.m_128441_(TAG_ACTIONS_DONE)) {
            this.actionsDone = compound.m_128451_(TAG_ACTIONS_DONE);
        }
    }

    @Override
    public void serializeToView(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.getJobRegistryEntry().getKey().toString());
        buffer.writeInt(this.getAsyncRequests().size());
        for (IToken<?> token : this.getAsyncRequests()) {
            StandardFactoryController.getInstance().serialize(buffer, token);
        }
        buffer.writeRegistryId(IJobRegistry.getInstance(), (Object)this.getJobRegistryEntry());
    }

    @Override
    public Set<IToken<?>> getAsyncRequests() {
        return this.asyncRequests;
    }

    @Override
    public void markRequestSync(IToken<?> id) {
        this.asyncRequests.remove(id);
    }

    @Override
    public void createAI() {
        AbstractAISkeleton tempAI = (AbstractAISkeleton)this.generateAI();
        if (tempAI == null) {
            Log.getLogger().error("Failed to create AI for citizen!", (Throwable)new Exception());
            if (this.citizen == null) {
                Log.getLogger().error("CitizenData is null for job: " + this.nameTag + " jobClass: " + this.getClass(), (Throwable)new Exception());
                return;
            }
            Log.getLogger().error("Affected Citizen name:" + this.citizen.getName() + " id:" + this.citizen.getId() + " job:" + this.citizen.getJob() + " jobForAICreation:" + this.nameTag + " class:" + this.getClass() + " entityPresent:" + this.citizen.getEntity().isPresent());
            return;
        }
        this.citizen.getEntity().get().getCitizenJobHandler().setWorkAI(tempAI);
    }

    @Override
    public boolean hasCheckedForFoodToday() {
        return this.searchedForFoodToday;
    }

    @Override
    public void setCheckedForFood() {
        this.searchedForFoodToday = true;
    }

    @Override
    public String getNameTagDescription() {
        return this.nameTag;
    }

    @Override
    public final void setNameTag(String nameTag) {
        this.nameTag = nameTag;
    }

    @Override
    public void triggerDeathAchievement(DamageSource source, AbstractEntityCitizen citizen) {
    }

    @Override
    public boolean onStackPickUp(@NotNull ItemStack pickedUpStack) {
        if (this.getCitizen().getWorkBuilding() != null && this.getCitizen().getWorkBuilding().overruleNextOpenRequestOfCitizenWithStack(this.getCitizen(), pickedUpStack.m_41777_())) {
            return true;
        }
        if (this.getCitizen().getHomeBuilding() != null) {
            return this.getCitizen().getHomeBuilding().overruleNextOpenRequestOfCitizenWithStack(this.getCitizen(), pickedUpStack.m_41777_());
        }
        return false;
    }

    @Override
    public ICitizenData getCitizen() {
        return this.citizen;
    }

    @Override
    public void onWakeUp() {
        this.searchedForFoodToday = false;
    }

    @Override
    public boolean canAIBeInterrupted() {
        if (this.getWorkerAI() instanceof AbstractAISkeleton) {
            return ((AbstractAISkeleton)this.getWorkerAI()).canBeInterrupted();
        }
        return true;
    }

    @Override
    public int getActionsDone() {
        return this.actionsDone;
    }

    @Override
    public void incrementActionsDone() {
        ++this.actionsDone;
    }

    @Override
    public void incrementActionsDone(int numberOfActions) {
        this.actionsDone += numberOfActions;
    }

    @Override
    public void clearActionsDone() {
        this.actionsDone = 0;
    }

    @Override
    public AI getWorkerAI() {
        if (this.citizen.getEntity().isPresent()) {
            return (AI)((AbstractAISkeleton)this.citizen.getEntity().get().getCitizenJobHandler().getWorkAI());
        }
        return null;
    }

    @Override
    public boolean isIdling() {
        return this.getWorkerAI() != null && ((AbstractAISkeleton)this.getWorkerAI()).getState() == AIWorkerState.IDLE;
    }

    @Override
    public void resetAI() {
        if (this.getWorkerAI() != null) {
            ((AbstractAISkeleton)this.getWorkerAI()).resetAI();
        }
    }

    @Override
    public boolean allowsAvoidance() {
        return true;
    }

    @Override
    public int getDiseaseModifier() {
        return 1;
    }

    @Override
    public void onRemoval() {
        if (this.getWorkerAI() != null) {
            ((AbstractAISkeleton)this.getWorkerAI()).onRemoval();
        }
    }

    @Override
    public boolean ignoresDamage(@NotNull DamageSource damageSource) {
        return false;
    }

    @Override
    public void processOfflineTime(long time) {
    }
}

