/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorkerModule;
import com.minecolonies.api.colony.buildings.modules.IAssignsCitizen;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import java.util.function.Function;
import net.minecraft.network.chat.MutableComponent;

public class WorkAtHomeBuildingModule
extends WorkerBuildingModule
implements IAssignsCitizen,
IBuildingEventsModule,
ITickingModule,
IPersistentModule,
IBuildingWorkerModule,
ICreatesResolversModule {
    public WorkAtHomeBuildingModule(JobEntry entry, Skill primary, Skill secondary, boolean canWorkingDuringRain, Function<IBuilding, Integer> sizeLimit) {
        super(entry, primary, secondary, canWorkingDuringRain, sizeLimit);
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (super.assignCitizen(citizen) && citizen != null) {
            IBuilding oldHome = citizen.getHomeBuilding();
            if (oldHome != null && !oldHome.getID().equals((Object)this.building.getID())) {
                if (oldHome.hasModule(LivingBuildingModule.class) && !oldHome.hasModule(WorkAtHomeBuildingModule.class)) {
                    MutableComponent jobComponent = MessageUtils.format(citizen.getJob().getJobRegistryEntry().getTranslationKey(), new Object[0]).create();
                    MutableComponent buildingComponent = MessageUtils.format(oldHome.getBuildingDisplayName(), new Object[0]).create();
                    MessageUtils.format("com.minecolonies.coremod.gui.workerhuts.assignedbed", citizen.getName(), jobComponent, buildingComponent, BlockPosUtil.getString(oldHome.getID())).sendTo(oldHome.getColony()).forAllPlayers();
                }
                if (oldHome.hasModule(LivingBuildingModule.class)) {
                    ((LivingBuildingModule)oldHome.getFirstModuleOccurance(LivingBuildingModule.class)).removeCitizen(citizen);
                }
            }
            citizen.setHomeBuilding(this.building);
            return true;
        }
        return false;
    }

    @Override
    void onRemoval(ICitizenData citizen) {
        super.onRemoval(citizen);
        citizen.setHomeBuilding(null);
    }
}

